/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.GraphVisualizationData;
import eu.stratosphere.addons.visualization.swt.InstanceVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTGraphCanvas;
import eu.stratosphere.addons.visualization.swt.SWTTopologyCanvas;
import eu.stratosphere.addons.visualization.swt.SWTVisualizationGUI;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.topology.NetworkTopology;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SWTJobTabItem
extends Composite
implements Listener {
    private final ChartComposite cpuChart;
    private final ChartComposite memoryChart;
    private final ChartComposite networkChart;
    private final TabFolder tabFolder;
    private final SWTGraphCanvas graphCanvas;
    private final SWTTopologyCanvas topologyCanvas;
    private final GraphVisualizationData visualizationData;
    private final SWTVisualizationGUI visualizationGUI;

    public SWTJobTabItem(SWTVisualizationGUI visualizationGUI, GraphVisualizationData visualizationData, Composite parent, int style, boolean detectBottlenecks) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.visualizationGUI = visualizationGUI;
        this.visualizationData = visualizationData;
        if (visualizationData.isProfilingAvailableForJob()) {
            SashForm verticalSash = new SashForm((Composite)this, 512);
            this.tabFolder = new TabFolder((Composite)verticalSash, 1024);
            this.tabFolder.addListener(13, (Listener)this);
            TabItem graphItem = new TabItem(this.tabFolder, 0);
            this.graphCanvas = new SWTGraphCanvas(visualizationData, this, (Composite)this.tabFolder, 0, detectBottlenecks);
            graphItem.setControl((Control)this.graphCanvas);
            graphItem.setText("Execution Graph");
            TabItem topologyItem = new TabItem(this.tabFolder, 0);
            this.topologyCanvas = new SWTTopologyCanvas(visualizationData, this, (Composite)this.tabFolder, 0);
            topologyItem.setControl((Control)this.topologyCanvas);
            topologyItem.setText("Allocated Instances");
            Composite statisticsComposite = new Composite((Composite)verticalSash, 0);
            statisticsComposite.setLayout((Layout)new FillLayout(256));
            NetworkTopology networkTopology = visualizationData.getNetworkTopology();
            InstanceVisualizationData summaryDataset = (InstanceVisualizationData)networkTopology.getAttachment();
            this.cpuChart = this.initializeCPUChart(statisticsComposite, summaryDataset.getCpuDataSet());
            this.memoryChart = this.initializeMemoryChart(statisticsComposite, summaryDataset.getMemoryDataSet());
            this.networkChart = this.initializeNetworkChart(statisticsComposite, summaryDataset.getNetworkDataSet());
            verticalSash.setWeights(new int[]{7, 3});
        } else {
            this.tabFolder = new TabFolder((Composite)this, 1024);
            TabItem graphItem = new TabItem(this.tabFolder, 0);
            this.graphCanvas = new SWTGraphCanvas(visualizationData, this, (Composite)this.tabFolder, 0, detectBottlenecks);
            graphItem.setControl((Control)this.graphCanvas);
            graphItem.setText("Execution Graph");
            TabItem topologyItem = new TabItem(this.tabFolder, 0);
            this.topologyCanvas = new SWTTopologyCanvas(visualizationData, this, (Composite)this.tabFolder, 0);
            topologyItem.setControl((Control)this.topologyCanvas);
            topologyItem.setText("Allocated Instances");
            this.cpuChart = null;
            this.memoryChart = null;
            this.networkChart = null;
        }
    }

    private ChartComposite initializeCPUChart(Composite parentComposite, TableXYDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart((String)"CPU", (String)"Time [sec.]", (String)"Average CPU utilization [%]", (TableXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setAutoRange(false);
        xyPlot.getRangeAxis().setRange(0.0, 100.0);
        return new ChartComposite(parentComposite, 0, chart, true);
    }

    private ChartComposite initializeMemoryChart(Composite parentComposite, TableXYDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart((String)"Memory", (String)"Time [sec.]", (String)"Average amount of memory allocated [MB]", (TableXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        InstanceVisualizationData instanceVisualizationData = (InstanceVisualizationData)this.visualizationData.getNetworkTopology().getAttachment();
        xyPlot.getRangeAxis().setAutoRange(false);
        xyPlot.getRangeAxis().setRange(0.0, instanceVisualizationData.getUpperBoundForMemoryChart());
        return new ChartComposite(parentComposite, 0, chart, true);
    }

    private ChartComposite initializeNetworkChart(Composite parentComposite, TableXYDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart((String)"Network", (String)"Time [sec.]", (String)"Average throughput [MBit/s]", (TableXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setAutoRange(false);
        xyPlot.getRangeAxis().setRange(0.0, 4096.0);
        return new ChartComposite(parentComposite, 0, chart, true);
    }

    public void updateView() {
        if (this.cpuChart != null) {
            this.cpuChart.getChart().getXYPlot().configureDomainAxes();
            this.cpuChart.getChart().fireChartChanged();
        }
        if (this.memoryChart != null) {
            InstanceVisualizationData instanceVisualizationData = (InstanceVisualizationData)this.visualizationData.getNetworkTopology().getAttachment();
            double newUpperBound = instanceVisualizationData.getUpperBoundForMemoryChart();
            if (newUpperBound > this.memoryChart.getChart().getXYPlot().getRangeAxis().getUpperBound()) {
                this.memoryChart.getChart().getXYPlot().getRangeAxis().setRange(0.0, newUpperBound);
            }
            this.memoryChart.getChart().getXYPlot().configureDomainAxes();
            this.memoryChart.getChart().fireChartChanged();
        }
        if (this.networkChart != null) {
            this.networkChart.getChart().getXYPlot().configureDomainAxes();
            this.networkChart.getChart().getXYPlot().configureRangeAxes();
            this.networkChart.getChart().fireChartChanged();
        }
        if (this.tabFolder.getSelectionIndex() == 0) {
            this.graphCanvas.updateView();
        } else {
            this.topologyCanvas.updateView();
        }
    }

    public void switchToInstance(String instanceName) {
        MessageBox messageBox = new MessageBox(this.getShell(), 1);
        messageBox.setText("Unsupported feature");
        messageBox.setMessage("Displaying profiling data of individual instances is currently not supported.");
        messageBox.open();
    }

    public void handleEvent(Event arg0) {
    }

    public void tabSelected() {
    }

    public void tabDeselected() {
    }

    public void killTask(ManagementVertexID id, String taskName) {
        this.visualizationGUI.killTask(this.visualizationData.getJobID(), id, taskName);
    }

    public void killInstance(String instanceName) {
        this.visualizationGUI.killInstance(instanceName);
    }
}

