/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.JobFailurePattern;
import eu.stratosphere.addons.visualization.swt.JobFailurePatternTreeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class SWTJobFailurePatternTree
extends Composite {
    private final Tree jobTree;
    private final MenuItem addItem;
    private final MenuItem removeItem;
    private final MenuItem saveItem;
    private final MenuItem loadItem;

    SWTJobFailurePatternTree(Composite parent, int style, final JobFailurePatternTreeListener treeListener) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        Menu treeContextMenu = new Menu((Control)this.getShell());
        this.addItem = new MenuItem(treeContextMenu, 8);
        this.addItem.setText("Add...");
        this.addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                treeListener.addFailurePattern();
            }
        });
        new MenuItem(treeContextMenu, 2);
        this.removeItem = new MenuItem(treeContextMenu, 8);
        this.removeItem.setText("Remove...");
        this.removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TreeItem[] selectedItems = SWTJobFailurePatternTree.this.jobTree.getSelection();
                if (selectedItems == null) {
                    return;
                }
                for (TreeItem selectedItem : selectedItems) {
                    treeListener.removeFailurePattern(selectedItem);
                }
            }
        });
        new MenuItem(treeContextMenu, 2);
        this.saveItem = new MenuItem(treeContextMenu, 8);
        this.saveItem.setText("Save...");
        this.saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TreeItem[] selectedItems = SWTJobFailurePatternTree.this.jobTree.getSelection();
                if (selectedItems == null) {
                    return;
                }
                for (TreeItem selectedItem : selectedItems) {
                    treeListener.saveFailurePattern(selectedItem);
                }
            }
        });
        this.loadItem = new MenuItem(treeContextMenu, 8);
        this.loadItem.setText("Load...");
        this.loadItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                treeListener.loadFailurePattern();
            }
        });
        this.jobTree = new Tree((Composite)this, style);
        this.jobTree.setMenu(treeContextMenu);
        this.jobTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                boolean itemSelected = SWTJobFailurePatternTree.this.jobTree.getItem(new Point(arg0.x, arg0.y)) != null;
                SWTJobFailurePatternTree.this.addItem.setEnabled(!itemSelected);
                SWTJobFailurePatternTree.this.removeItem.setEnabled(itemSelected);
                SWTJobFailurePatternTree.this.saveItem.setEnabled(itemSelected);
                SWTJobFailurePatternTree.this.loadItem.setEnabled(!itemSelected);
            }
        });
        this.jobTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode == 127) {
                    TreeItem[] selectedItems = SWTJobFailurePatternTree.this.jobTree.getSelection();
                    if (selectedItems == null) {
                        return;
                    }
                    for (TreeItem selectedItem : selectedItems) {
                        treeListener.removeFailurePattern(selectedItem);
                    }
                }
            }
        });
        this.jobTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TreeItem[] selectedItems = SWTJobFailurePatternTree.this.jobTree.getSelection();
                if (selectedItems == null) {
                    return;
                }
                for (TreeItem selectedItem : selectedItems) {
                    treeListener.jobFailurePatternSelected(selectedItem);
                }
            }
        });
    }

    public int getItemCount() {
        return this.jobTree.getItemCount();
    }

    public TreeItem getItem(int index) {
        return this.jobTree.getItem(index);
    }

    public void setSelection(TreeItem treeItem) {
        this.jobTree.setSelection(treeItem);
    }

    public TreeItem[] getSelection() {
        return this.jobTree.getSelection();
    }

    public void addFailurePatternToTree(JobFailurePattern failurePattern) {
        TreeItem jobFailureItem = new TreeItem(this.jobTree, 0);
        jobFailureItem.setText(failurePattern.getName());
        jobFailureItem.setData((Object)failurePattern);
        this.jobTree.setSelection(jobFailureItem);
    }
}

