/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.InstanceVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.nephele.topology.NetworkNode;
import java.awt.Paint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SWTInstanceToolTip
extends SWTToolTip {
    private final NetworkNode networkNode;
    private final ChartComposite cpuChart;
    private final ChartComposite memoryChart;
    private final ChartComposite networkChart;
    private static final int WIDTH = 400;

    public SWTInstanceToolTip(Shell parent, final SWTToolTipCommandReceiver commandReceiver, NetworkNode networkNode, int x, int y) {
        super(parent, x, y);
        int height;
        this.networkNode = networkNode;
        Color backgroundColor = this.getShell().getBackground();
        Color foregroundColor = this.getShell().getForeground();
        boolean isProfilingEnabled = false;
        InstanceVisualizationData instanceVisualizationData = (InstanceVisualizationData)networkNode.getAttachment();
        if (instanceVisualizationData != null) {
            isProfilingEnabled = instanceVisualizationData.isProfilingEnabledForJob();
        }
        this.setTitle(networkNode.getName());
        if (isProfilingEnabled) {
            this.cpuChart = this.createCPUChart(instanceVisualizationData, backgroundColor);
            this.cpuChart.setLayoutData((Object)new GridData(1808));
            this.memoryChart = this.createMemoryChart(instanceVisualizationData, backgroundColor);
            this.memoryChart.setLayoutData((Object)new GridData(1808));
            this.networkChart = this.createNetworkChart(instanceVisualizationData, backgroundColor);
            this.networkChart.setLayoutData((Object)new GridData(1808));
            height = 460;
        } else {
            this.cpuChart = null;
            this.memoryChart = null;
            this.networkChart = null;
            height = 75;
        }
        Composite instanceActionComposite = new Composite((Composite)this.getShell(), 0);
        instanceActionComposite.setLayout((Layout)new RowLayout(256));
        instanceActionComposite.setBackground(backgroundColor);
        instanceActionComposite.setForeground(foregroundColor);
        Button killInstanceButton = new Button(instanceActionComposite, 8);
        final String instanceName = this.networkNode.getName();
        killInstanceButton.setText("Kill instance...");
        killInstanceButton.setEnabled(this.networkNode.isLeafNode());
        killInstanceButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                commandReceiver.killInstance(instanceName);
            }
        });
        this.getShell().setSize(400, height);
        this.finishInstantiation(x, y, 400, false);
    }

    private ChartComposite createCPUChart(InstanceVisualizationData instanceVisualizationData, Color backgroundColor) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart(null, (String)"Time [sec.]", (String)"CPU", (TableXYDataset)instanceVisualizationData.getCpuDataSet(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new java.awt.Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()));
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setAutoRange(false);
        xyPlot.getRangeAxis().setRange(0.0, 100.0);
        return new ChartComposite((Composite)this.getShell(), 0, chart, true);
    }

    private ChartComposite createMemoryChart(InstanceVisualizationData instanceVisualizationData, Color backgroundColor) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart(null, (String)"Time [sec.]", (String)"Memory", (TableXYDataset)instanceVisualizationData.getMemoryDataSet(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new java.awt.Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()));
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setAutoRange(false);
        xyPlot.getRangeAxis().setRange(0.0, instanceVisualizationData.getUpperBoundForMemoryChart());
        return new ChartComposite((Composite)this.getShell(), 0, chart, true);
    }

    private ChartComposite createNetworkChart(InstanceVisualizationData instanceVisualizationData, Color backgroundColor) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart(null, (String)"Time [sec.]", (String)"Network", (TableXYDataset)instanceVisualizationData.getNetworkDataSet(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new java.awt.Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()));
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setAutoRange(false);
        xyPlot.getRangeAxis().setRange(0.0, 4096.0);
        return new ChartComposite((Composite)this.getShell(), 0, chart, true);
    }

    @Override
    public void updateView() {
        if (this.cpuChart != null) {
            this.cpuChart.getChart().getXYPlot().configureDomainAxes();
            this.cpuChart.getChart().fireChartChanged();
        }
        if (this.memoryChart != null) {
            InstanceVisualizationData instanceVisualizationData = (InstanceVisualizationData)this.networkNode.getAttachment();
            double newUpperBound = instanceVisualizationData.getUpperBoundForMemoryChart();
            if (newUpperBound > this.memoryChart.getChart().getXYPlot().getRangeAxis().getUpperBound()) {
                this.memoryChart.getChart().getXYPlot().getRangeAxis().setRange(0.0, newUpperBound);
            }
            this.memoryChart.getChart().getXYPlot().configureDomainAxes();
            this.memoryChart.getChart().fireChartChanged();
        }
        if (this.networkChart != null) {
            this.networkChart.getChart().getXYPlot().configureDomainAxes();
            this.networkChart.getChart().fireChartChanged();
        }
    }
}

