/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.AbstractSWTVertex;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import eu.stratosphere.addons.visualization.swt.FontScheme;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class SWTGroupVertex
extends AbstractSWTVertex {
    private static final int SPACING = 5;
    private static final int NAMERECTWIDTH = 50;
    private static final int ARC_DIM = 20;
    private final ManagementGroupVertex managementGroupVertex;

    public SWTGroupVertex(AbstractSWTComponent parent, ManagementGroupVertex managementGroupVertex) {
        super(parent);
        this.managementGroupVertex = managementGroupVertex;
    }

    @Override
    public void layout() {
        int numberOfChildren = this.getNumberOfChildren();
        if (numberOfChildren == 0) {
            return;
        }
        int width = (this.getWidth() - 50) / numberOfChildren - 10;
        int height = this.getHeight() - 10;
        int y = this.getY() + 5;
        for (int i = 0; i < numberOfChildren; ++i) {
            AbstractSWTComponent child = this.getChildAt(i);
            int x = this.getX() + 50 + (i + 1) * 5 + i * (width + 5);
            child.setX(x);
            child.setY(y);
            child.setWidth(width);
            child.setHeight(height);
        }
        this.layoutChildren();
    }

    private String cropStringToSize(GC gc, String originalString, int maximumWidth) {
        String croppedString = originalString;
        boolean cropped = false;
        Point pt = gc.textExtent(originalString);
        while (pt.x >= maximumWidth) {
            cropped = true;
            if ((croppedString = croppedString.substring(0, croppedString.length() - 1)).length() == 0) break;
            pt = gc.textExtent(croppedString + "...");
        }
        if (cropped) {
            croppedString = croppedString + "...";
        }
        return croppedString;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        gc.setBackground(ColorScheme.getGroupVertexBackgroundColor(device));
        gc.fillRoundRectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height, 20, 20);
        int oldWidth = gc.getLineWidth();
        gc.setLineWidth(6);
        gc.setForeground(ColorScheme.getGroupVertexBorderColor(device));
        this.drawVerticalText(gc, this.managementGroupVertex.getName());
        gc.setLineWidth(oldWidth);
    }

    private void drawVerticalText(GC gc, String text) {
        Font oldFont = gc.getFont();
        gc.setFont(FontScheme.getGroupVertexFont(gc.getDevice()));
        int maximumWidth = this.getHeight() - 10;
        String croppedText = this.cropStringToSize(gc, text, maximumWidth);
        Point pt = gc.stringExtent(croppedText);
        gc.setFont(oldFont);
        Image textImage = new Image(gc.getDevice(), pt.x, pt.y);
        GC textGC = new GC((Drawable)textImage);
        textGC.setBackground(gc.getBackground());
        textGC.fillRectangle(textImage.getBounds());
        textGC.setFont(FontScheme.getGroupVertexFont(textGC.getDevice()));
        textGC.drawText(croppedText, 0, 0);
        Image rotatedImage = SWTGroupVertex.rotateImage(gc.getDevice(), textImage);
        gc.drawImage(rotatedImage, this.rect.x + 5 + (50 - pt.y) / 2, this.rect.y + 5 + (maximumWidth - pt.x) / 2);
        rotatedImage.dispose();
        textGC.dispose();
        textImage.dispose();
    }

    private static Image rotateImage(Device device, Image originalImage) {
        ImageData sd = originalImage.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        for (int sx = 0; sx < sd.width; ++sx) {
            for (int sy = 0; sy < sd.height; ++sy) {
                dd.setPixel(sy, sd.width - sx - 1, sd.getPixel(sx, sy));
            }
        }
        return new Image(device, dd);
    }
}

