/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.GraphVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTGate;
import eu.stratosphere.addons.visualization.swt.SWTGraph;
import eu.stratosphere.addons.visualization.swt.SWTGroupVertex;
import eu.stratosphere.addons.visualization.swt.SWTJobTabItem;
import eu.stratosphere.addons.visualization.swt.SWTStage;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.addons.visualization.swt.SWTVertex;
import eu.stratosphere.nephele.managementgraph.ManagementEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGraphIterator;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementStage;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTGraphCanvas
extends Canvas
implements PaintListener,
Listener,
MouseMoveListener,
Runnable,
SWTToolTipCommandReceiver {
    private final SWTGraph swtGraph;
    private final SWTJobTabItem jobTabItem;
    private final GraphVisualizationData visualizationData;
    private final boolean detectBottlenecks;
    private final String FAKE_TAIL = "Fake Tail";
    private final String ITERATION_SYNC = "Iteration Sync";
    private AbstractSWTComponent toolTipComponent = null;
    private SWTToolTip displayedToolTip = null;
    private volatile boolean runAnimation = false;

    public SWTGraphCanvas(GraphVisualizationData visualizationData, SWTJobTabItem jobTabItem, Composite parent, int style, boolean detectBottlenecks) {
        super(parent, style);
        this.visualizationData = visualizationData;
        this.swtGraph = this.createSWTGraph(visualizationData);
        this.jobTabItem = jobTabItem;
        this.detectBottlenecks = detectBottlenecks;
        this.addMouseMoveListener(this);
        this.addListener(11, this);
        this.addPaintListener(this);
    }

    public void paintControl(PaintEvent arg0) {
        this.swtGraph.paint(arg0.gc, (Device)this.getDisplay());
    }

    private SWTGraph createSWTGraph(GraphVisualizationData visualizationData) {
        ManagementGraph managementGraph = visualizationData.getManagementGraph();
        SWTGraph swtGraph = new SWTGraph();
        Map<ManagementStage, SWTStage> stageMap = this.addManagementStages(swtGraph, managementGraph);
        Map<ManagementGroupVertex, SWTGroupVertex> groupMap = this.addGroupVertices(stageMap);
        this.addExecutionVertices(groupMap, managementGraph, visualizationData);
        return swtGraph;
    }

    private Map<ManagementStage, SWTStage> addManagementStages(SWTGraph swtGraph, ManagementGraph managementGraph) {
        HashMap<ManagementStage, SWTStage> stageMap = new HashMap<ManagementStage, SWTStage>();
        SWTStage previousVisualStage = null;
        for (int i = 0; i < managementGraph.getNumberOfStages(); ++i) {
            ManagementStage executionStage = managementGraph.getStage(i);
            SWTStage visualStage = new SWTStage(swtGraph);
            stageMap.put(executionStage, visualStage);
            if (previousVisualStage != null) {
                previousVisualStage.connectTo(visualStage);
            }
            previousVisualStage = visualStage;
        }
        return stageMap;
    }

    private Map<ManagementGroupVertex, SWTGroupVertex> addGroupVertices(Map<ManagementStage, SWTStage> stageMap) {
        HashMap<ManagementGroupVertex, SWTGroupVertex> groupMap = new HashMap<ManagementGroupVertex, SWTGroupVertex>();
        for (Map.Entry<ManagementStage, SWTStage> entry : stageMap.entrySet()) {
            ManagementStage managementStage = entry.getKey();
            SWTStage parent = entry.getValue();
            for (int i = 0; i < managementStage.getNumberOfGroupVertices(); ++i) {
                ManagementGroupVertex groupVertex = managementStage.getGroupVertex(i);
                if (groupVertex.getName().equals(this.FAKE_TAIL) || groupVertex.getName().contains(this.ITERATION_SYNC)) continue;
                SWTGroupVertex visualGroupVertex = new SWTGroupVertex(parent, groupVertex);
                groupMap.put(groupVertex, visualGroupVertex);
            }
        }
        for (Map.Entry<ManagementStage, SWTStage> entry : stageMap.entrySet()) {
            ManagementStage executionStage = entry.getKey();
            for (int i = 0; i < executionStage.getNumberOfGroupVertices(); ++i) {
                ManagementGroupVertex sourceVertex = executionStage.getGroupVertex(i);
                SWTGroupVertex sourceGroupVertex = (SWTGroupVertex)groupMap.get(sourceVertex);
                for (int j = 0; j < sourceVertex.getNumberOfForwardEdges(); ++j) {
                    ManagementGroupEdge edge = sourceVertex.getForwardEdge(j);
                    ManagementGroupVertex targetVertex = edge.getTarget();
                    SWTGroupVertex targetGroupVertex = (SWTGroupVertex)groupMap.get(targetVertex);
                    sourceGroupVertex.connectTo(targetGroupVertex);
                }
            }
        }
        return groupMap;
    }

    private void addExecutionVertices(Map<ManagementGroupVertex, SWTGroupVertex> groupMap, ManagementGraph managementGraph, GraphVisualizationData visualizationData) {
        ManagementGraphIterator iterator = new ManagementGraphIterator(managementGraph, true);
        HashMap<ManagementVertex, SWTVertex> vertexMap = new HashMap<ManagementVertex, SWTVertex>();
        HashMap<ManagementGate, SWTGate> gateMap = new HashMap<ManagementGate, SWTGate>();
        while (iterator.hasNext()) {
            SWTGate visualGate;
            int gateIndex;
            ManagementVertex mv = iterator.next();
            SWTGroupVertex parent = groupMap.get(mv.getGroupVertex());
            if (mv.getName().equals(this.FAKE_TAIL) || mv.getName().contains(this.ITERATION_SYNC)) continue;
            SWTVertex visualVertex = new SWTVertex(parent, mv);
            vertexMap.put(mv, visualVertex);
            for (gateIndex = 0; gateIndex < mv.getNumberOfOutputGates(); ++gateIndex) {
                ManagementGate outputGate = mv.getOutputGate(gateIndex);
                visualGate = new SWTGate(visualVertex, outputGate);
                gateMap.put(outputGate, visualGate);
            }
            for (gateIndex = 0; gateIndex < mv.getNumberOfInputGates(); ++gateIndex) {
                ManagementGate inputGate = mv.getInputGate(gateIndex);
                visualGate = new SWTGate(visualVertex, inputGate);
                gateMap.put(inputGate, visualGate);
            }
        }
        iterator = new ManagementGraphIterator(managementGraph, true);
        while (iterator.hasNext()) {
            ManagementVertex source = iterator.next();
            SWTVertex visualSource = (SWTVertex)vertexMap.get(source);
            for (int i = 0; i < source.getNumberOfOutputGates(); ++i) {
                ManagementGate sourceGate = source.getOutputGate(i);
                SWTGate visualSourceGate = (SWTGate)gateMap.get(sourceGate);
                for (int j = 0; j < sourceGate.getNumberOfForwardEdges(); ++j) {
                    ManagementEdge forwardEdge = sourceGate.getForwardEdge(j);
                    SWTVertex visualTarget = (SWTVertex)vertexMap.get(forwardEdge.getTarget().getVertex());
                    SWTGate visualTargetGate = (SWTGate)gateMap.get(forwardEdge.getTarget());
                    visualSource.connectTo(visualTarget);
                    visualSourceGate.connectTo(visualTargetGate);
                }
            }
        }
    }

    public void handleEvent(Event arg0) {
        if (this.swtGraph != null) {
            Rectangle rect = this.getClientArea();
            this.swtGraph.setX(rect.x);
            this.swtGraph.setY(rect.y);
            this.swtGraph.setWidth(rect.width);
            this.swtGraph.setHeight(rect.height);
            this.swtGraph.layout();
        }
    }

    public void mouseMove(MouseEvent arg0) {
        AbstractSWTComponent selectedComponent = this.swtGraph.getSelectedComponent(arg0.x, arg0.y);
        if (selectedComponent == null) {
            if (this.toolTipComponent != null) {
                this.displayedToolTip.dispose();
                this.displayedToolTip = null;
                this.toolTipComponent = null;
            }
        } else {
            Point clientPoint = this.toDisplay(arg0.x, arg0.y);
            if (selectedComponent == this.toolTipComponent) {
                if (this.displayedToolTip != null) {
                    this.displayedToolTip.move(clientPoint.x, clientPoint.y);
                }
            } else {
                if (this.displayedToolTip != null && !this.displayedToolTip.isDisposed()) {
                    this.displayedToolTip.dispose();
                }
                this.displayedToolTip = selectedComponent.constructToolTip(this.getShell(), this, clientPoint.x, clientPoint.y);
                if (this.displayedToolTip != null) {
                    this.displayedToolTip.move(clientPoint.x, clientPoint.y);
                    this.toolTipComponent = selectedComponent;
                } else {
                    this.toolTipComponent = null;
                }
            }
        }
    }

    public void updateView() {
        if (this.detectBottlenecks) {
            this.visualizationData.detectBottlenecks();
        }
        this.redraw();
        if (this.displayedToolTip != null && !this.displayedToolTip.isDisposed()) {
            this.displayedToolTip.updateView();
        }
    }

    @Override
    public void run() {
        if (!this.isDisposed()) {
            this.redraw();
            if (this.runAnimation) {
                this.getDisplay().timerExec(50, (Runnable)this);
            }
        }
    }

    @Override
    public void switchToInstance(String instanceName) {
        if (this.displayedToolTip != null) {
            if (!this.displayedToolTip.isDisposed()) {
                this.displayedToolTip.dispose();
            }
            this.displayedToolTip = null;
            this.toolTipComponent = null;
        }
        this.jobTabItem.switchToInstance(instanceName);
    }

    public void startAnimation() {
        if (this.runAnimation) {
            return;
        }
        if (!this.getDisplay().isDisposed()) {
            this.getDisplay().timerExec(50, (Runnable)this);
            this.runAnimation = true;
        }
    }

    public void stopAnimation() {
        this.runAnimation = false;
    }

    @Override
    public void killTask(ManagementVertexID id, String taskName) {
        this.jobTabItem.killTask(id, taskName);
    }

    @Override
    public void killInstance(String instanceName) {
    }
}

