/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.AbstractSWTVertex;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class SWTGraph
extends AbstractSWTComponent {
    private static final int SPACING = 5;

    public SWTGraph() {
        super(null);
    }

    @Override
    public void layout() {
        int totalLongestPath = 0;
        int[] longestPath = new int[this.getNumberOfChildren()];
        for (int i = 0; i < this.getNumberOfChildren(); ++i) {
            AbstractSWTComponent child = this.getChildAt(i);
            if (child instanceof AbstractSWTVertex) {
                AbstractSWTVertex childVertex = (AbstractSWTVertex)child;
                longestPath[i] = 1 + childVertex.getLongestPathAmongChildren();
            } else {
                longestPath[i] = 1;
            }
            totalLongestPath += longestPath[i];
        }
        if (totalLongestPath == 0) {
            return;
        }
        int heightPerPathSegment = this.getHeight() / totalLongestPath;
        AbstractSWTComponent last = null;
        int width = this.getWidth() - 10;
        int x = this.getX() + 5;
        for (int i = 0; i < this.getNumberOfChildren(); ++i) {
            AbstractSWTComponent child = this.getChildAt(i);
            child.setX(x);
            child.setWidth(width);
            int height = heightPerPathSegment * longestPath[i] - 10;
            child.setHeight(height);
            if (last == null) {
                child.setY(this.getY() + this.getHeight() - child.getHeight() - 5);
            } else {
                child.setY(last.getY() - child.getHeight() - 10);
            }
            last = child;
        }
        this.layoutChildren();
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        gc.setBackground(ColorScheme.getGraphBackgroundColor(device));
        gc.fillRectangle(this.rect);
    }
}

