/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.GateVisualizationData;
import eu.stratosphere.addons.visualization.swt.GroupEdgeVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.nephele.io.channels.ChannelType;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import java.awt.Paint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SWTGateToolTip
extends SWTToolTip {
    private static final String WARNINGTEXT = "Nephele has detected an I/O bottleneck at this gate";
    private final ChartComposite chart;
    private final Label channelTypeLabel;
    private Composite warningComposite;
    private static final int WIDTH = 400;
    private final ManagementGate managementGate;

    public SWTGateToolTip(Shell parent, ManagementGate managementGate, int x, int y) {
        super(parent, x, y);
        int height;
        this.managementGate = managementGate;
        if (managementGate.isInputGate()) {
            this.setTitle("Input Gate " + managementGate.getIndex());
        } else {
            this.setTitle("Output Gate " + managementGate.getIndex());
        }
        Color backgroundColor = this.getShell().getBackground();
        Color foregroundColor = this.getShell().getForeground();
        GateVisualizationData gateVisualizationData = (GateVisualizationData)managementGate.getAttachment();
        if (gateVisualizationData.isProfilingEnabled()) {
            this.chart = this.createChart(gateVisualizationData, backgroundColor);
            this.chart.setLayoutData((Object)new GridData(1808));
            height = 200;
        } else {
            this.chart = null;
            height = 100;
        }
        Composite tableComposite = new Composite((Composite)this.getShell(), 0);
        tableComposite.setBackground(backgroundColor);
        tableComposite.setForeground(foregroundColor);
        GridLayout tableGridLayout = new GridLayout(2, false);
        tableGridLayout.marginHeight = 0;
        tableGridLayout.marginLeft = 0;
        tableComposite.setLayout((Layout)tableGridLayout);
        ChannelType channelType = managementGate.isInputGate() ? managementGate.getVertex().getGroupVertex().getBackwardEdge(managementGate.getIndex()).getChannelType() : managementGate.getVertex().getGroupVertex().getForwardEdge(managementGate.getIndex()).getChannelType();
        Label channelTypeTextLabel = new Label(tableComposite, 0);
        channelTypeTextLabel.setBackground(backgroundColor);
        channelTypeTextLabel.setForeground(foregroundColor);
        channelTypeTextLabel.setText("Channel type:");
        this.channelTypeLabel = new Label(tableComposite, 0);
        this.channelTypeLabel.setBackground(backgroundColor);
        this.channelTypeLabel.setForeground(foregroundColor);
        this.channelTypeLabel.setText(channelType.toString());
        if (!this.managementGate.isInputGate()) {
            ManagementGroupEdge groupEdge = this.managementGate.getVertex().getGroupVertex().getForwardEdge(this.managementGate.getIndex());
            GroupEdgeVisualizationData groupEdgeVisualizationData = (GroupEdgeVisualizationData)groupEdge.getAttachment();
            if (groupEdgeVisualizationData.isIOBottleneck()) {
                this.warningComposite = this.createWarningComposite(WARNINGTEXT, 8);
                height += 20;
            } else {
                this.warningComposite = null;
            }
        } else {
            this.warningComposite = null;
        }
        this.getShell().setSize(400, height);
        this.finishInstantiation(x, y, 400, false);
    }

    private ChartComposite createChart(GateVisualizationData visualizationData, Color backgroundColor) {
        String yAxisLabel = this.managementGate.isInputGate() ? "No data available/sec." : "Capacity limit reached/sec.";
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Time [sec.]", (String)yAxisLabel, (XYDataset)visualizationData.getChartCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)new java.awt.Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()));
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setAutoRange(true);
        return new ChartComposite((Composite)this.getShell(), 0, chart, true);
    }

    @Override
    public void updateView() {
        if (this.chart != null) {
            this.chart.getChart().getXYPlot().configureDomainAxes();
            this.chart.getChart().fireChartChanged();
        }
        if (!this.managementGate.isInputGate()) {
            ManagementGroupEdge groupEdge = this.managementGate.getVertex().getGroupVertex().getForwardEdge(this.managementGate.getIndex());
            GroupEdgeVisualizationData groupEdgeVisualizationData = (GroupEdgeVisualizationData)groupEdge.getAttachment();
            if (groupEdgeVisualizationData.isIOBottleneck()) {
                if (this.warningComposite == null) {
                    this.warningComposite = this.createWarningComposite(WARNINGTEXT, 8);
                    Rectangle clientRect = this.getShell().getClientArea();
                    clientRect.height += 20;
                    this.getShell().setSize(clientRect.width, clientRect.height);
                }
            } else if (this.warningComposite != null) {
                this.warningComposite.dispose();
                this.warningComposite = null;
                Rectangle clientRect = this.getShell().getClientArea();
                clientRect.height -= 20;
                this.getShell().setSize(clientRect.width, clientRect.height);
            }
        } else if (this.warningComposite != null) {
            this.warningComposite.dispose();
            this.warningComposite = null;
            Rectangle clientRect = this.getShell().getClientArea();
            clientRect.height -= 20;
            this.getShell().setSize(clientRect.width, clientRect.height);
        }
    }
}

