/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.AbstractSWTVertex;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import eu.stratosphere.addons.visualization.swt.GroupEdgeVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTGateToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;

public class SWTGate
extends AbstractSWTVertex {
    private final ManagementGate mangementGate;

    protected SWTGate(AbstractSWTComponent parent, ManagementGate managementGate) {
        super(parent);
        this.mangementGate = managementGate;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void layout() {
    }

    private Color getBorderColor(Device device) {
        ExecutionState executionState = this.mangementGate.getVertex().getExecutionState();
        Color returnColor = null;
        switch (executionState) {
            case RUNNING: {
                returnColor = ColorScheme.getGateRunningBorderColor(device);
                break;
            }
            case FINISHING: {
                returnColor = ColorScheme.getGateFinishingBorderColor(device);
                break;
            }
            case FINISHED: {
                returnColor = ColorScheme.getGateFinishedBorderColor(device);
                break;
            }
            case CANCELING: 
            case CANCELED: {
                returnColor = ColorScheme.getGateCancelBorderColor(device);
                break;
            }
            case FAILED: {
                returnColor = ColorScheme.getGateFailedBorderColor(device);
                break;
            }
            default: {
                returnColor = ColorScheme.getGateDefaultBorderColor(device);
            }
        }
        return returnColor;
    }

    private Color getBackgroundColor(Device device) {
        ExecutionState executionState = this.mangementGate.getVertex().getExecutionState();
        Color returnColor = null;
        switch (executionState) {
            case RUNNING: {
                returnColor = ColorScheme.getGateRunningBackgroundColor(device);
                break;
            }
            case FINISHING: {
                returnColor = ColorScheme.getGateFinishingBackgroundColor(device);
                break;
            }
            case FINISHED: {
                returnColor = ColorScheme.getGateFinishedBackgroundColor(device);
                break;
            }
            case CANCELING: 
            case CANCELED: {
                returnColor = ColorScheme.getGateCancelBackgroundColor(device);
                break;
            }
            case FAILED: {
                returnColor = ColorScheme.getGateFailedBackgroundColor(device);
                break;
            }
            default: {
                returnColor = ColorScheme.getGateDefaultBackgroundColor(device);
            }
        }
        return returnColor;
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        gc.setForeground(this.getBorderColor(device));
        Iterator<AbstractSWTVertex> iterator = this.getEdges();
        while (iterator.hasNext()) {
            this.paintArrow(gc, iterator.next());
        }
        if (this.mangementGate.isInputGate()) {
            gc.setBackground(this.getBackgroundColor(device));
        } else {
            ManagementGroupEdge groupEdge = this.mangementGate.getVertex().getGroupVertex().getForwardEdge(this.mangementGate.getIndex());
            GroupEdgeVisualizationData groupEdgeVisualizationData = (GroupEdgeVisualizationData)groupEdge.getAttachment();
            if (groupEdgeVisualizationData.isIOBottleneck()) {
                gc.setBackground(this.getBackgroundColor(device));
            } else {
                gc.setBackground(this.getBackgroundColor(device));
            }
        }
        gc.fillRectangle(this.rect);
        gc.drawRectangle(this.rect);
    }

    private void paintArrow(GC gc, AbstractSWTVertex target) {
        int sourcex = this.getEdgeSourceX();
        int sourcey = this.getEdgeSourceY();
        int targetx = target.getEdgeTargetX();
        int targety = target.getEdgeTargetY();
        gc.drawLine(sourcex, sourcey, targetx, targety);
    }

    public boolean isInputGate() {
        return this.mangementGate.isInputGate();
    }

    @Override
    public SWTToolTip constructToolTip(Shell parentShell, SWTToolTipCommandReceiver commandReceiver, int x, int y) {
        return new SWTGateToolTip(parentShell, this.mangementGate, x, y);
    }
}

