/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.JobFailurePattern;
import eu.stratosphere.addons.visualization.swt.JobFailurePatternExecutor;
import eu.stratosphere.addons.visualization.swt.SWTFailurePatternsEditor;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.protocols.ExtendedManagementProtocol;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class SWTFailurePatternsManager {
    private static final Log LOG = LogFactory.getLog(SWTFailurePatternsManager.class);
    private final Display display;
    private final ExtendedManagementProtocol jobManager;
    private Map<String, JobFailurePattern> failurePatterns = new HashMap<String, JobFailurePattern>();

    public SWTFailurePatternsManager(Display display, ExtendedManagementProtocol jobManager) {
        this.display = display;
        this.jobManager = jobManager;
    }

    public void startFailurePattern(String jobName, ManagementGraph managementGraph, long referenceTime) {
        JobFailurePattern failurePattern = this.failurePatterns.get(jobName);
        if (failurePattern == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No failure pattern for job " + jobName));
            }
            return;
        }
        LOG.info((Object)("Starting failure pattern for job " + jobName));
        new JobFailurePatternExecutor(this.display, this.jobManager, managementGraph, failurePattern, referenceTime);
    }

    public void openEditor(Shell parent, Set<String> jobSuggestions, Set<String> nameSuggestions) {
        SWTFailurePatternsEditor editor = new SWTFailurePatternsEditor(parent, jobSuggestions, nameSuggestions, this.failurePatterns);
        editor.show();
    }

    public static String getSuggestedName(ManagementVertex vertex) {
        String vertexName = vertex.getName() != null ? vertex.getName() : "null";
        return vertexName + " " + (vertex.getIndexInGroup() + 1);
    }
}

