/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractFailureEvent;
import eu.stratosphere.addons.visualization.swt.InstanceFailureEvent;
import eu.stratosphere.addons.visualization.swt.JobFailurePattern;
import eu.stratosphere.addons.visualization.swt.JobFailurePatternTreeListener;
import eu.stratosphere.addons.visualization.swt.SWTFailureEventTable;
import eu.stratosphere.addons.visualization.swt.SWTJobFailurePatternTree;
import eu.stratosphere.addons.visualization.swt.SWTNewFailurePatternDialog;
import eu.stratosphere.addons.visualization.swt.VertexFailureEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class SWTFailurePatternsEditor
implements JobFailurePatternTreeListener {
    private static final int WIDTH = 800;
    private static final int HEIGHT = 400;
    private final Shell shell;
    private final SWTJobFailurePatternTree jobTree;
    private final SWTFailureEventTable failureEventTable;
    private final Set<String> jobSuggestions;
    private final Map<String, JobFailurePattern> loadedPatterns;

    SWTFailurePatternsEditor(Shell parent, Set<String> jobSuggestions, Set<String> nameSuggestions, Map<String, JobFailurePattern> loadedPatterns) {
        this.jobSuggestions = jobSuggestions;
        this.loadedPatterns = loadedPatterns;
        this.shell = new Shell(parent);
        this.shell.setSize(800, 400);
        this.shell.setText("Manage Failure Patterns");
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginBottom = 0;
        gl.marginTop = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.shell.setLayout((Layout)gl);
        Composite mainComposite = new Composite((Composite)this.shell, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)gridData);
        SashForm horizontalSash = new SashForm(mainComposite, 256);
        horizontalSash.setLayoutData((Object)new GridData(1808));
        Group jobGroup = new Group((Composite)horizontalSash, 0);
        jobGroup.setText("Job Failure Patterns");
        jobGroup.setLayout((Layout)new FillLayout());
        this.jobTree = new SWTJobFailurePatternTree((Composite)jobGroup, 2052, this);
        this.failureEventTable = new SWTFailureEventTable((Composite)horizontalSash, 2052, nameSuggestions);
        horizontalSash.setWeights(new int[]{2, 8});
        Composite buttonComposite = new Composite((Composite)this.shell, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        buttonComposite.setLayoutData((Object)gridData);
        Label fillLabel = new Label(buttonComposite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        fillLabel.setLayoutData((Object)gridData);
        Button closeButton = new Button(buttonComposite, 8);
        closeButton.setText("Close");
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        closeButton.setLayoutData((Object)gridData);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTFailurePatternsEditor.this.shell.dispose();
            }
        });
        Iterator<JobFailurePattern> it = this.loadedPatterns.values().iterator();
        while (it.hasNext()) {
            this.jobTree.addFailurePatternToTree(it.next());
        }
        if (this.jobTree.getItemCount() > 0) {
            TreeItem ti = this.jobTree.getItem(0);
            this.jobTree.setSelection(ti);
            this.failureEventTable.showFailurePattern((JobFailurePattern)ti.getData());
        } else {
            this.failureEventTable.showFailurePattern(null);
        }
    }

    public Map<String, JobFailurePattern> show() {
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.loadedPatterns;
    }

    @Override
    public void addFailurePattern() {
        Set<String> takenNames = this.loadedPatterns.keySet();
        SWTNewFailurePatternDialog dialog = new SWTNewFailurePatternDialog(this.shell, this.jobSuggestions, takenNames);
        String patternName = dialog.showDialog();
        if (patternName == null) {
            return;
        }
        JobFailurePattern jobFailurePattern = new JobFailurePattern(patternName);
        this.loadedPatterns.put(jobFailurePattern.getName(), jobFailurePattern);
        this.jobTree.addFailurePatternToTree(jobFailurePattern);
        this.failureEventTable.showFailurePattern(jobFailurePattern);
    }

    @Override
    public void removeFailurePattern(TreeItem selectedItem) {
        JobFailurePattern failurePattern = (JobFailurePattern)selectedItem.getData();
        if (failurePattern == null) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.shell, 196);
        messageBox.setText("Confirm Removal");
        messageBox.setMessage("Do you really want to remove the job failure pattern '" + failurePattern.getName() + "'?");
        if (messageBox.open() != 64) {
            return;
        }
        selectedItem.dispose();
        this.loadedPatterns.remove(failurePattern.getName());
        if (this.jobTree.getItemCount() == 0) {
            this.jobFailurePatternSelected(null);
        } else {
            TreeItem ti = this.jobTree.getItem(0);
            this.jobTree.setSelection(ti);
            this.jobFailurePatternSelected(ti);
        }
    }

    @Override
    public void saveFailurePattern(TreeItem selectedItem) {
        JobFailurePattern failurePattern = (JobFailurePattern)selectedItem.getData();
        if (failurePattern == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setText("Save Failure Pattern");
        String[] filterExts = new String[]{"*.xml", "*.*"};
        fileDialog.setFilterExtensions(filterExts);
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("pattern");
            doc.appendChild(root);
            Element name = doc.createElement("name");
            root.appendChild(name);
            name.appendChild(doc.createTextNode(failurePattern.getName()));
            Element failures = doc.createElement("failures");
            root.appendChild(failures);
            Iterator<AbstractFailureEvent> it = failurePattern.iterator();
            while (it.hasNext()) {
                AbstractFailureEvent event = it.next();
                Element failure = doc.createElement("failure");
                failure.setAttribute("type", event instanceof VertexFailureEvent ? "task" : "instance");
                Element failureName = doc.createElement("name");
                failureName.appendChild(doc.createTextNode(event.getName()));
                failure.appendChild(failureName);
                Element interval = doc.createElement("interval");
                interval.appendChild(doc.createTextNode(Integer.toString(event.getInterval())));
                failure.appendChild(interval);
                failures.appendChild(failure);
            }
            DOMSource domSource = new DOMSource(doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            FileOutputStream fos = new FileOutputStream(selectedFile);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(domSource, new StreamResult(fos));
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Cannot Save Failure Pattern");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
        }
    }

    @Override
    public void jobFailurePatternSelected(TreeItem selectedItem) {
        if (selectedItem == null) {
            this.failureEventTable.showFailurePattern(null);
        } else {
            this.failureEventTable.showFailurePattern((JobFailurePattern)selectedItem.getData());
        }
    }

    @Override
    public void loadFailurePattern() {
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        fileDialog.setText("Load Failure Pattern");
        String[] filterExts = new String[]{"*.xml", "*.*"};
        fileDialog.setFilterExtensions(filterExts);
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        JobFailurePattern failurePattern = this.loadFailurePatternFromFile(selectedFile);
        if (this.loadedPatterns.containsKey(failurePattern.getName())) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Cannot Load Failure Pattern");
            messageBox.setMessage("There is already a failure pattern loaded with the name '" + failurePattern.getName() + "'. Please remove it first.");
            messageBox.open();
            return;
        }
        this.loadedPatterns.put(failurePattern.getName(), failurePattern);
        this.jobTree.addFailurePatternToTree(failurePattern);
        this.failureEventTable.showFailurePattern(failurePattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobFailurePattern loadFailurePatternFromFile(String filename) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setNamespaceAware(true);
        JobFailurePattern jobFailurePattern = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filename);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            doc = builder.parse(inputStream);
            if (doc == null) {
                throw new Exception("Document is null");
            }
            root = doc.getDocumentElement();
            if (root == null) {
                throw new Exception("Root element is null");
            }
            if (!"pattern".equals(root.getNodeName())) {
                throw new Exception("Encountered unknown element " + root.getNodeName());
            }
            NodeList patternChildren = root.getChildNodes();
            for (int i = 0; i < patternChildren.getLength(); ++i) {
                Node patternChild = patternChildren.item(i);
                if (patternChild instanceof Text) continue;
                if (patternChild instanceof Element) {
                    Element patternElement = (Element)patternChild;
                    if ("name".equals(patternElement.getNodeName())) {
                        String name = this.extractValueFromElement(patternElement);
                        if (jobFailurePattern != null) {
                            throw new Exception("Element name detected more than once in the file");
                        }
                        jobFailurePattern = new JobFailurePattern(name);
                        continue;
                    }
                    if ("failures".equals(patternElement.getNodeName())) {
                        if (jobFailurePattern == null) {
                            throw new Exception("Expected pattern name to be stored before the failure events");
                        }
                        NodeList failuresChildren = patternElement.getChildNodes();
                        for (int j = 0; j < failuresChildren.getLength(); ++j) {
                            Node failuresChild = failuresChildren.item(j);
                            if (failuresChild instanceof Text) continue;
                            if (!(failuresChild instanceof Element)) {
                                throw new Exception("Expected type element as child of element 'failures'");
                            }
                            Element failuresElement = (Element)failuresChild;
                            if (!"failure".equals(failuresElement.getNodeName())) {
                                throw new Exception("Expected element 'failure' as child of element 'failures'");
                            }
                            String type = failuresElement.getAttribute("type");
                            if (type == null) {
                                throw new Exception("Element 'failure' lacks the attribute 'type'");
                            }
                            boolean taskFailure = "task".equals(type);
                            String name = null;
                            String interval = null;
                            NodeList failureChildren = failuresElement.getChildNodes();
                            for (int k = 0; k < failureChildren.getLength(); ++k) {
                                Node failureChild = failureChildren.item(k);
                                if (failureChild instanceof Text) continue;
                                if (!(failureChild instanceof Element)) {
                                    throw new Exception("Expected type element as child of element 'failure'");
                                }
                                Element failureElement = (Element)failureChild;
                                if ("name".equals(failureElement.getNodeName())) {
                                    name = this.extractValueFromElement(failureElement);
                                }
                                if (!"interval".equals(failureElement.getNodeName())) continue;
                                interval = this.extractValueFromElement(failureElement);
                            }
                            if (name == null) {
                                throw new Exception("Could not find name for failure event " + j);
                            }
                            if (interval == null) {
                                throw new Exception("Could not find interval for failure event " + j);
                            }
                            int iv = 0;
                            try {
                                iv = Integer.parseInt(interval);
                            }
                            catch (NumberFormatException e) {
                                throw new Exception("Interval " + interval + " for failure event " + j + " is not an integer number");
                            }
                            if (iv <= 0) {
                                throw new Exception("Interval for failure event " + j + " must be greather than zero, but is " + iv);
                            }
                            AbstractFailureEvent failureEvent = null;
                            failureEvent = taskFailure ? new VertexFailureEvent(name, iv) : new InstanceFailureEvent(name, iv);
                            jobFailurePattern.addEvent(failureEvent);
                        }
                        continue;
                    }
                    throw new Exception("Uncountered unecpted element " + patternElement.getNodeName());
                }
                throw new Exception("Encountered unexpected child of type " + patternChild.getClass());
            }
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Cannot Load Failure Pattern");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            JobFailurePattern jobFailurePattern2 = null;
            return jobFailurePattern2;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {}
            }
        }
        return jobFailurePattern;
    }

    private String extractValueFromElement(Element element) throws Exception {
        NodeList children = element.getChildNodes();
        if (children.getLength() != 1) {
            throw new Exception("Element " + element.getNodeName() + " has an unexpected number of children");
        }
        Node child = children.item(0);
        if (!(child instanceof Text)) {
            throw new Exception("Expected child of element " + element.getNodeName() + " to be of type text");
        }
        Text childText = (Text)child;
        return childText.getTextContent();
    }
}

