/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractFailureEvent;
import eu.stratosphere.addons.visualization.swt.JobFailurePattern;
import eu.stratosphere.addons.visualization.swt.SWTFailureEventEditor;
import eu.stratosphere.addons.visualization.swt.VertexFailureEvent;
import eu.stratosphere.util.StringUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class SWTFailureEventTable
extends Composite {
    private static final Log LOG = LogFactory.getLog(SWTFailureEventTable.class);
    private static final int DEFAULT_ICON_SIZE = 16;
    private static final int ICON_COLUMN_WIDTH = 20;
    private static final int TEXT_COLUMN_WIDTH = 200;
    private static Image TASK_ICON = null;
    private static Image INSTANCE_ICON = null;
    private final Table failureEventTable;
    private final Set<String> nameSuggestions;
    private JobFailurePattern selectedFailurePattern = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTFailureEventTable(Composite parent, int style, Set<String> nameSuggestions) {
        super(parent, 0);
        Class<SWTFailureEventTable> clazz = SWTFailureEventTable.class;
        synchronized (SWTFailureEventTable.class) {
            if (TASK_ICON == null) {
                TASK_ICON = this.loadIcon("/eu/stratosphere/nephele/visualization/swt/taskicon.png");
            }
            if (INSTANCE_ICON == null) {
                INSTANCE_ICON = this.loadIcon("/eu/stratosphere/nephele/visualization/swt/nodeicon.png");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.nameSuggestions = nameSuggestions;
            this.setLayout((Layout)new FillLayout());
            this.failureEventTable = new Table((Composite)this, style);
            this.failureEventTable.setHeaderVisible(true);
            this.failureEventTable.setLinesVisible(true);
            final TableColumn iconColumn = new TableColumn(this.failureEventTable, 0);
            final TableColumn nameColumn = new TableColumn(this.failureEventTable, 0);
            nameColumn.setText("Name");
            TableColumn intervalColumn = new TableColumn(this.failureEventTable, 0);
            intervalColumn.setText("Interval");
            for (int i = 0; i < this.failureEventTable.getColumnCount(); ++i) {
                if (i == 0) {
                    this.failureEventTable.getColumn(i).setWidth(20);
                    continue;
                }
                this.failureEventTable.getColumn(i).setWidth(200);
            }
            this.failureEventTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    TableItem ti = SWTFailureEventTable.this.failureEventTable.getItem(new Point(arg0.x, arg0.y));
                    if (SWTFailureEventTable.this.selectedFailurePattern == null) {
                        return;
                    }
                    SWTFailureEventTable.this.addOrEditTableItem(ti);
                }
            });
            Listener sortListener = new Listener(){

                public void handleEvent(Event arg0) {
                    int i;
                    TableColumn sortColumn = SWTFailureEventTable.this.failureEventTable.getSortColumn();
                    final TableColumn currentColumn = (TableColumn)arg0.widget;
                    int dir = SWTFailureEventTable.this.failureEventTable.getSortDirection();
                    if (sortColumn == currentColumn) {
                        dir = dir == 128 ? 1024 : 128;
                    } else {
                        SWTFailureEventTable.this.failureEventTable.setSortColumn(currentColumn);
                        dir = 128;
                    }
                    final int direction = dir;
                    AbstractFailureEvent[] failureEvents = new AbstractFailureEvent[SWTFailureEventTable.this.failureEventTable.getItemCount()];
                    for (i = 0; i < SWTFailureEventTable.this.failureEventTable.getItemCount(); ++i) {
                        failureEvents[i] = (AbstractFailureEvent)SWTFailureEventTable.this.failureEventTable.getItem(i).getData();
                    }
                    Arrays.sort(failureEvents, new Comparator<AbstractFailureEvent>(){

                        @Override
                        public int compare(AbstractFailureEvent o1, AbstractFailureEvent o2) {
                            if (o1 == null) {
                                return -1;
                            }
                            if (o2 == null) {
                                return 1;
                            }
                            if (currentColumn == iconColumn) {
                                int v1 = o1 instanceof VertexFailureEvent ? 0 : 1;
                                int v2 = o2 instanceof VertexFailureEvent ? 0 : 1;
                                return direction == 128 ? v1 - v2 : v2 - v1;
                            }
                            if (currentColumn == nameColumn) {
                                if (direction == 128) {
                                    return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
                                }
                                return String.CASE_INSENSITIVE_ORDER.compare(o2.getName(), o1.getName());
                            }
                            if (direction == 128) {
                                return o1.getInterval() - o2.getInterval();
                            }
                            return o2.getInterval() - o1.getInterval();
                        }
                    });
                    SWTFailureEventTable.this.failureEventTable.removeAll();
                    for (i = 0; i < failureEvents.length; ++i) {
                        SWTFailureEventTable.this.updateTableItem(null, failureEvents[i]);
                    }
                    SWTFailureEventTable.this.failureEventTable.setSortColumn(currentColumn);
                    SWTFailureEventTable.this.failureEventTable.setSortDirection(direction);
                }
            };
            iconColumn.addListener(13, sortListener);
            nameColumn.addListener(13, sortListener);
            intervalColumn.addListener(13, sortListener);
            this.failureEventTable.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent arg0) {
                    if (arg0.keyCode == 127) {
                        SWTFailureEventTable.this.removeSelectedTableItems();
                    } else if (arg0.keyCode == 13) {
                        SWTFailureEventTable.this.addOrEditSelectedTableItems();
                    }
                }
            });
            this.failureEventTable.setMenu(this.createTableContextMenu());
            return;
        }
    }

    private Image loadIcon(String path) {
        Display display = this.getDisplay();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        try {
            return new Image((Device)display, in);
        }
        catch (Exception e) {
            LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            Image image = new Image((Device)display, 16, 16);
            GC gc = new GC((Drawable)image);
            gc.setBackground(display.getSystemColor(1));
            gc.fillRectangle(image.getBounds());
            gc.dispose();
            return image;
        }
    }

    private void updateTableItem(TableItem ti, AbstractFailureEvent event) {
        boolean newItemCreated = false;
        if (ti == null) {
            int index = this.failureEventTable.getItemCount() == 0 ? 0 : this.failureEventTable.getItemCount() - 1;
            ti = new TableItem(this.failureEventTable, 0, index);
            newItemCreated = true;
        }
        if (event != null) {
            if (event instanceof VertexFailureEvent) {
                ti.setImage(TASK_ICON);
            } else {
                ti.setImage(INSTANCE_ICON);
            }
            ti.setText(1, event.getName());
            ti.setText(2, Integer.toString(event.getInterval()));
        }
        if (ti.getData() == null && !newItemCreated) {
            new TableItem(this.failureEventTable, 0);
        }
        ti.setData((Object)event);
    }

    private Menu createTableContextMenu() {
        Menu tableContextMenu = new Menu((Control)this.getShell());
        MenuItem addItem = new MenuItem(tableContextMenu, 8);
        addItem.setText("Add...");
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTFailureEventTable.this.addOrEditSelectedTableItems();
            }
        });
        final MenuItem editItem = new MenuItem(tableContextMenu, 8);
        editItem.setText("Edit...");
        editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTFailureEventTable.this.addOrEditSelectedTableItems();
            }
        });
        final MenuItem removeItem = new MenuItem(tableContextMenu, 8);
        removeItem.setText("Remove...");
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTFailureEventTable.this.removeSelectedTableItems();
            }
        });
        tableContextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent arg0) {
                TableItem[] selectedItems = SWTFailureEventTable.this.failureEventTable.getSelection();
                if (selectedItems == null) {
                    return;
                }
                if (selectedItems.length == 0) {
                    editItem.setEnabled(false);
                    removeItem.setEnabled(false);
                    return;
                }
                if (selectedItems[0].getData() == null) {
                    editItem.setEnabled(false);
                    removeItem.setEnabled(false);
                    return;
                }
                editItem.setEnabled(true);
                removeItem.setEnabled(true);
            }
        });
        return tableContextMenu;
    }

    private void addOrEditSelectedTableItems() {
        TableItem[] selectedItems = this.failureEventTable.getSelection();
        if (selectedItems == null) {
            return;
        }
        for (TableItem selectedItem : selectedItems) {
            this.addOrEditTableItem(selectedItem);
        }
    }

    private void addOrEditTableItem(TableItem ti) {
        SWTFailureEventEditor editor;
        AbstractFailureEvent newEvent;
        AbstractFailureEvent oldEvent = null;
        if (ti != null) {
            oldEvent = (AbstractFailureEvent)ti.getData();
        }
        if ((newEvent = (editor = new SWTFailureEventEditor(this.getShell(), this.nameSuggestions, oldEvent)).showDialog()) == null) {
            return;
        }
        if (oldEvent != null) {
            this.selectedFailurePattern.removeEvent(oldEvent);
        }
        this.selectedFailurePattern.addEvent(newEvent);
        this.updateTableItem(ti, newEvent);
    }

    private void removeSelectedTableItems() {
        TableItem[] selectedItems = this.failureEventTable.getSelection();
        if (selectedItems == null) {
            return;
        }
        for (TableItem selectedItem : selectedItems) {
            this.removeTableItem(selectedItem);
        }
    }

    private void removeTableItem(TableItem ti) {
        AbstractFailureEvent event = (AbstractFailureEvent)ti.getData();
        if (event == null) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setText("Confirm removal");
        messageBox.setMessage("Do you really want to remove the event '" + event.getName() + "'");
        if (messageBox.open() == 64) {
            ti.dispose();
        }
        this.selectedFailurePattern.removeEvent(event);
    }

    public void showFailurePattern(JobFailurePattern jobFailurePattern) {
        this.failureEventTable.removeAll();
        if (jobFailurePattern == null) {
            this.failureEventTable.setEnabled(false);
            return;
        }
        this.failureEventTable.setEnabled(true);
        Iterator<AbstractFailureEvent> it = jobFailurePattern.iterator();
        while (it.hasNext()) {
            AbstractFailureEvent event = it.next();
            TableItem ti = new TableItem(this.failureEventTable, 0);
            ti.setData((Object)event);
            this.updateTableItem(ti, event);
        }
        new TableItem(this.failureEventTable, 0);
        this.selectedFailurePattern = jobFailurePattern;
    }
}

