/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractFailureEvent;
import eu.stratosphere.addons.visualization.swt.AutoCompletionCombo;
import eu.stratosphere.addons.visualization.swt.InstanceFailureEvent;
import eu.stratosphere.addons.visualization.swt.VertexFailureEvent;
import java.util.Set;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SWTFailureEventEditor {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 200;
    private final Shell shell;
    private final AutoCompletionCombo name;
    private final Text interval;
    private final Button taskFailureButton;
    private final Button instanceFailureButton;
    private AbstractFailureEvent returnValue = null;

    public SWTFailureEventEditor(Shell parent, Set<String> nameSuggestions, AbstractFailureEvent failureEvent) {
        this.shell = new Shell(parent);
        this.shell.setSize(300, 200);
        String title = null;
        title = failureEvent == null ? "Add Failure Event" : "Edit Failure Event";
        this.shell.setText(title);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 1;
        labelGridData.grabExcessHorizontalSpace = false;
        labelGridData.grabExcessVerticalSpace = false;
        labelGridData.widthHint = 50;
        labelGridData.minimumWidth = 50;
        Label nameLabel = new Label((Composite)this.shell, 0);
        nameLabel.setText("Name:");
        nameLabel.setLayoutData((Object)labelGridData);
        GridData fieldGridData = new GridData();
        fieldGridData.horizontalAlignment = 4;
        fieldGridData.grabExcessHorizontalSpace = true;
        fieldGridData.grabExcessVerticalSpace = false;
        this.name = new AutoCompletionCombo((Composite)this.shell, 0, nameSuggestions);
        this.name.setLayoutData(fieldGridData);
        this.name.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.character != '\r') {
                    return;
                }
                if (SWTFailureEventEditor.this.isInputValid()) {
                    SWTFailureEventEditor.this.returnValue = SWTFailureEventEditor.this.assembleReturnValue();
                    SWTFailureEventEditor.this.shell.dispose();
                }
            }
        });
        if (failureEvent != null) {
            this.name.setText(failureEvent.getName());
        }
        Label intervalLabel = new Label((Composite)this.shell, 0);
        intervalLabel.setText("Interval:");
        intervalLabel.setLayoutData((Object)labelGridData);
        this.interval = new Text((Composite)this.shell, 2052);
        this.interval.setLayoutData((Object)fieldGridData);
        this.interval.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.character != '\r') {
                    return;
                }
                if (SWTFailureEventEditor.this.isInputValid()) {
                    SWTFailureEventEditor.this.returnValue = SWTFailureEventEditor.this.assembleReturnValue();
                    SWTFailureEventEditor.this.shell.dispose();
                }
            }
        });
        if (failureEvent != null) {
            this.interval.setText(Integer.toString(failureEvent.getInterval()));
        }
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.grabExcessVerticalSpace = false;
        groupGridData.horizontalSpan = 2;
        Group typeGroup = new Group((Composite)this.shell, 2048);
        typeGroup.setText("Event type");
        typeGroup.setLayoutData((Object)groupGridData);
        typeGroup.setLayout((Layout)new GridLayout(1, true));
        this.taskFailureButton = new Button((Composite)typeGroup, 16);
        this.taskFailureButton.setText("Task failure");
        this.instanceFailureButton = new Button((Composite)typeGroup, 16);
        this.instanceFailureButton.setText("Instance failure");
        if (failureEvent == null) {
            this.taskFailureButton.setSelection(true);
            this.instanceFailureButton.setSelection(false);
        } else if (failureEvent instanceof VertexFailureEvent) {
            this.taskFailureButton.setSelection(true);
            this.instanceFailureButton.setSelection(false);
        } else {
            this.taskFailureButton.setSelection(false);
            this.instanceFailureButton.setSelection(true);
        }
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 131072;
        buttonGridData.verticalAlignment = 1024;
        buttonGridData.grabExcessHorizontalSpace = true;
        buttonGridData.grabExcessVerticalSpace = true;
        buttonGridData.horizontalSpan = 2;
        Composite buttonComposite = new Composite((Composite)this.shell, 0x4000000);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginBottom = 0;
        rowLayout.marginHeight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginWidth = 0;
        rowLayout.pack = false;
        buttonComposite.setLayoutData((Object)buttonGridData);
        buttonComposite.setLayout((Layout)rowLayout);
        Button ok = new Button(buttonComposite, 8);
        ok.setText("OK");
        ok.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SWTFailureEventEditor.this.isInputValid()) {
                    SWTFailureEventEditor.this.returnValue = SWTFailureEventEditor.this.assembleReturnValue();
                    SWTFailureEventEditor.this.shell.dispose();
                }
            }
        });
        Button cancel = new Button(buttonComposite, 8);
        cancel.setText("Cancel");
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SWTFailureEventEditor.this.returnValue = null;
                SWTFailureEventEditor.this.shell.dispose();
            }
        });
    }

    private AbstractFailureEvent assembleReturnValue() {
        String n = this.name.getText();
        int iv = Integer.parseInt(this.interval.getText());
        if (this.taskFailureButton.getSelection()) {
            return new VertexFailureEvent(n, iv);
        }
        return new InstanceFailureEvent(n, iv);
    }

    private boolean isInputValid() {
        if (this.name.getText().isEmpty()) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Invalid Input");
            messageBox.setMessage("Name must not be empty.");
            messageBox.open();
            this.name.setFocus();
            return false;
        }
        String intervalString = this.interval.getText();
        if (intervalString.isEmpty()) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Invalid Input");
            messageBox.setMessage("Interval must not be empty");
            messageBox.open();
            this.interval.setFocus();
            return false;
        }
        int interval = -1;
        try {
            interval = Integer.parseInt(intervalString);
        }
        catch (NumberFormatException nfe) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Invalid Input");
            messageBox.setMessage("Given interval is not an integer number");
            messageBox.open();
            this.interval.setFocus();
            return false;
        }
        if (interval <= 0) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Invalid Input");
            messageBox.setMessage("Given interval is must be greater than 0");
            messageBox.open();
            this.interval.setFocus();
            return false;
        }
        return true;
    }

    public AbstractFailureEvent showDialog() {
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnValue;
    }
}

