/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.ColorScheme;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class LogoCanvas
extends Canvas
implements PaintListener {
    private final Image stratosphereLogo;
    private final Image stratospherePattern;
    private final Rectangle stratosphereLogoRect;
    private final Rectangle stratospherePatternRect;
    private Point preferredSize = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogoCanvas(Composite parent, int style) {
        super(parent, style);
        Image stratosphereLogoTmp = null;
        Rectangle stratosphereLogoRectTmp = null;
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/eu/stratosphere/nephele/visualization/swt/logo.png");
        if (in != null) {
            try {
                stratosphereLogoTmp = this.loadImage(in);
                stratosphereLogoRectTmp = stratosphereLogoTmp.getBounds();
            }
            catch (SWTException e) {
                e.printStackTrace();
                stratosphereLogoRectTmp = new Rectangle(0, 0, 0, 0);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        } else {
            stratosphereLogoRectTmp = new Rectangle(0, 0, 0, 0);
        }
        this.stratosphereLogo = stratosphereLogoTmp;
        this.stratosphereLogoRect = stratosphereLogoRectTmp;
        Image stratospherePatternTmp = null;
        Rectangle stratospherePatternRectTmp = null;
        in = ((Object)((Object)this)).getClass().getResourceAsStream("/eu/stratosphere/nephele/visualization/swt/pattern.png");
        if (in != null) {
            try {
                stratospherePatternTmp = this.loadImage(in);
                stratospherePatternRectTmp = stratospherePatternTmp.getBounds();
            }
            catch (SWTException e) {
                e.printStackTrace();
                stratospherePatternRectTmp = new Rectangle(0, 0, 0, 0);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        } else {
            stratospherePatternRectTmp = new Rectangle(0, 0, 0, 0);
        }
        this.stratospherePattern = stratospherePatternTmp;
        this.stratospherePatternRect = stratospherePatternRectTmp;
        this.addPaintListener(this);
    }

    private Image loadImage(InputStream inputStream) {
        try {
            return new Image((Device)this.getDisplay(), inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void paintControl(PaintEvent arg0) {
        GC gc = arg0.gc;
        Rectangle rect = this.getBounds();
        gc.setBackground(ColorScheme.getLogoCanvasBackgroundColor((Device)this.getDisplay()));
        gc.fillRectangle(rect);
        if (this.stratosphereLogo != null && this.stratosphereLogoRect.height <= rect.height && this.stratosphereLogoRect.width <= rect.width) {
            gc.drawImage(this.stratosphereLogo, rect.x, rect.y);
        }
        if (this.stratospherePattern != null && this.stratospherePatternRect.height <= rect.height) {
            if (this.stratosphereLogo == null) {
                if (this.stratospherePatternRect.width <= rect.width) {
                    gc.drawImage(this.stratospherePattern, rect.x + rect.width - this.stratospherePatternRect.width, rect.y);
                }
            } else if (this.stratosphereLogoRect.width + this.stratospherePatternRect.width <= rect.width) {
                gc.drawImage(this.stratospherePattern, rect.x + rect.width - this.stratospherePatternRect.width, rect.y);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.preferredSize == null || changed) {
            this.preferredSize = this.stratospherePattern != null ? new Point(wHint, this.stratospherePattern.getBounds().height) : new Point(wHint, hHint);
        }
        return this.preferredSize;
    }
}

