/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractFailureEvent;
import eu.stratosphere.addons.visualization.swt.JobFailurePattern;
import eu.stratosphere.addons.visualization.swt.SWTFailurePatternsManager;
import eu.stratosphere.addons.visualization.swt.VertexFailureEvent;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGraphIterator;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.protocols.ExtendedManagementProtocol;
import eu.stratosphere.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;

public final class JobFailurePatternExecutor
implements Runnable {
    private static final Log LOG = LogFactory.getLog(JobFailurePatternExecutor.class);
    private final Display timer;
    private final JobID jobID;
    private final ExtendedManagementProtocol jobManager;
    private final Map<String, ManagementVertexID> nameToIDMap;
    private final Iterator<AbstractFailureEvent> eventIterator;
    private final int offset;
    private AbstractFailureEvent nextEvent = null;
    private boolean stopRequested = false;

    JobFailurePatternExecutor(Display timer, ExtendedManagementProtocol jobManager, ManagementGraph managementGraph, JobFailurePattern failurePattern, long referenceTime) {
        this.timer = timer;
        this.jobManager = jobManager;
        this.jobID = managementGraph.getJobID();
        long now = System.currentTimeMillis();
        this.offset = (int)(now - referenceTime);
        HashMap<String, ManagementVertexID> tmpMap = new HashMap<String, ManagementVertexID>();
        ManagementGraphIterator it = new ManagementGraphIterator(managementGraph, true);
        while (it.hasNext()) {
            ManagementVertex vertex = (ManagementVertex)it.next();
            tmpMap.put(SWTFailurePatternsManager.getSuggestedName(vertex), vertex.getID());
        }
        this.nameToIDMap = Collections.unmodifiableMap(tmpMap);
        this.eventIterator = failurePattern.iterator();
        this.scheduleNextEvent();
    }

    @Override
    public void run() {
        if (this.stopRequested) {
            LOG.info((Object)("Stopping job failure pattern executor for job " + this.jobID));
            this.stopRequested = false;
            return;
        }
        LOG.info((Object)("Triggering event " + this.nextEvent.getName() + " for job " + this.jobID));
        if (this.nextEvent instanceof VertexFailureEvent) {
            ManagementVertexID vertexID = this.nameToIDMap.get(this.nextEvent.getName());
            if (vertexID == null) {
                LOG.error((Object)("Cannot determine ID for vertex " + this.nextEvent.getName()));
            } else {
                try {
                    this.jobManager.killTask(this.jobID, vertexID);
                }
                catch (IOException ioe) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
                }
            }
        } else {
            try {
                this.jobManager.killInstance(new StringRecord(this.nextEvent.getName()));
            }
            catch (IOException ioe) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
            }
        }
        this.scheduleNextEvent();
    }

    public void stop() {
        this.stopRequested = true;
    }

    private void scheduleNextEvent() {
        if (!this.eventIterator.hasNext()) {
            this.nextEvent = null;
            return;
        }
        this.nextEvent = this.eventIterator.next();
        int interval = this.nextEvent.getInterval() - this.offset;
        this.timer.timerExec(interval, (Runnable)this);
    }
}

