/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractFailureEvent;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public final class JobFailurePattern {
    private final String name;
    private final SortedSet<AbstractFailureEvent> events = new TreeSet<AbstractFailureEvent>();

    public JobFailurePattern(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name must not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Argument name must not be empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addEvent(AbstractFailureEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument event must not be null");
        }
        if (this.events.contains(event)) {
            return;
        }
        this.events.add(event);
    }

    public void removeEvent(AbstractFailureEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument event must not be null");
        }
        this.events.remove(event);
    }

    public Iterator<AbstractFailureEvent> iterator() {
        return this.events.iterator();
    }
}

