/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.VertexVisualizationData;
import eu.stratosphere.nephele.profiling.types.InstanceProfilingEvent;
import eu.stratosphere.nephele.profiling.types.ProfilingEvent;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class InstanceVisualizationData {
    private static final long BYTE_TO_MEGABIT = 131072L;
    private static final long KILOBYTE_TO_MEGABYTE = 1024L;
    private final DefaultTableXYDataset cpuDataSet;
    private final DefaultTableXYDataset memoryDataSet;
    private final DefaultTableXYDataset networkDataSet;
    private final XYSeries cpuUsrSeries;
    private final XYSeries cpuSysSeries;
    private final XYSeries cpuWaitSeries;
    private final XYSeries cpuHardIrqSeries;
    private final XYSeries cpuSoftIrqSeries;
    private final XYSeries networkReceivedSeries;
    private final XYSeries networkTransmittedSeries;
    private final XYSeries totalMemorySeries;
    private final XYSeries usedMemorySeries;
    private final XYSeries cachedMemorySeries;
    private final boolean isProfilingAvailable;
    private long totalMemoryinMB = 1024L;

    public InstanceVisualizationData(boolean isProfilingAvailable) {
        this.isProfilingAvailable = isProfilingAvailable;
        this.cpuDataSet = new DefaultTableXYDataset();
        this.memoryDataSet = new DefaultTableXYDataset();
        this.networkDataSet = new DefaultTableXYDataset();
        this.cpuUsrSeries = new XYSeries((Comparable)((Object)"USR"), false, false);
        this.cpuUsrSeries.setNotify(false);
        this.cpuSysSeries = new XYSeries((Comparable)((Object)"SYS"), false, false);
        this.cpuSysSeries.setNotify(false);
        this.cpuWaitSeries = new XYSeries((Comparable)((Object)"WAIT"), false, false);
        this.cpuWaitSeries.setNotify(false);
        this.cpuHardIrqSeries = new XYSeries((Comparable)((Object)"HI"), false, false);
        this.cpuHardIrqSeries.setNotify(false);
        this.cpuSoftIrqSeries = new XYSeries((Comparable)((Object)"SI"), false, false);
        this.cpuSoftIrqSeries.setNotify(false);
        this.cpuDataSet.addSeries(this.cpuWaitSeries);
        this.cpuDataSet.addSeries(this.cpuSysSeries);
        this.cpuDataSet.addSeries(this.cpuUsrSeries);
        this.cpuDataSet.addSeries(this.cpuHardIrqSeries);
        this.cpuDataSet.addSeries(this.cpuSoftIrqSeries);
        this.networkReceivedSeries = new XYSeries((Comparable)((Object)"Received"), false, false);
        this.networkReceivedSeries.setNotify(false);
        this.networkTransmittedSeries = new XYSeries((Comparable)((Object)"Transmitted"), false, false);
        this.networkTransmittedSeries.setNotify(false);
        this.networkDataSet.addSeries(this.networkReceivedSeries);
        this.networkDataSet.addSeries(this.networkTransmittedSeries);
        this.totalMemorySeries = new XYSeries((Comparable)((Object)"Total"), false, false);
        this.totalMemorySeries.setNotify(false);
        this.usedMemorySeries = new XYSeries((Comparable)((Object)"Used"), false, false);
        this.usedMemorySeries.setNotify(false);
        this.cachedMemorySeries = new XYSeries((Comparable)((Object)"Cached"), false, false);
        this.cachedMemorySeries.setNotify(false);
        this.memoryDataSet.addSeries(this.cachedMemorySeries);
        this.memoryDataSet.addSeries(this.usedMemorySeries);
    }

    public TableXYDataset getCpuDataSet() {
        return this.cpuDataSet;
    }

    public TableXYDataset getMemoryDataSet() {
        return this.memoryDataSet;
    }

    public TableXYDataset getNetworkDataSet() {
        return this.networkDataSet;
    }

    public double getUpperBoundForMemoryChart() {
        return (double)this.totalMemoryinMB * 1.05;
    }

    public void processInstanceProfilingEvent(InstanceProfilingEvent instanceProfilingEvent) {
        double timestamp = VertexVisualizationData.getTimestamp((ProfilingEvent)instanceProfilingEvent);
        long instanceMemoryInMB = instanceProfilingEvent.getTotalMemory() / 1024L;
        if (instanceMemoryInMB > this.totalMemoryinMB) {
            this.totalMemoryinMB = instanceMemoryInMB;
        }
        long cachedMemory = instanceProfilingEvent.getBufferedMemory() + instanceProfilingEvent.getCachedMemory() + instanceProfilingEvent.getCachedSwapMemory();
        long usedMemory = instanceProfilingEvent.getTotalMemory() - instanceProfilingEvent.getFreeMemory() - cachedMemory;
        this.cpuUsrSeries.addOrUpdate((Number)timestamp, (Number)instanceProfilingEvent.getUserCPU());
        this.cpuSysSeries.addOrUpdate((Number)timestamp, (Number)instanceProfilingEvent.getSystemCPU());
        this.cpuWaitSeries.addOrUpdate((Number)timestamp, (Number)instanceProfilingEvent.getIOWaitCPU());
        this.cpuHardIrqSeries.addOrUpdate((Number)timestamp, (Number)instanceProfilingEvent.getHardIrqCPU());
        this.cpuSoftIrqSeries.addOrUpdate((Number)timestamp, (Number)instanceProfilingEvent.getSoftIrqCPU());
        this.totalMemorySeries.addOrUpdate((Number)timestamp, (Number)(instanceProfilingEvent.getTotalMemory() / 1024L));
        this.usedMemorySeries.addOrUpdate((Number)timestamp, (Number)(usedMemory / 1024L));
        this.cachedMemorySeries.addOrUpdate((Number)timestamp, (Number)(cachedMemory / 1024L));
        this.networkReceivedSeries.addOrUpdate((Number)timestamp, (Number)this.toMBitPerSec(instanceProfilingEvent.getReceivedBytes(), instanceProfilingEvent.getProfilingInterval()));
        this.networkTransmittedSeries.addOrUpdate((Number)timestamp, (Number)this.toMBitPerSec(instanceProfilingEvent.getTransmittedBytes(), instanceProfilingEvent.getProfilingInterval()));
    }

    public double getAverageUserTime() {
        double av = 0.0;
        if (this.cpuUsrSeries != null) {
            av = this.calculateAverage(this.cpuUsrSeries.getItems());
        }
        return av;
    }

    private double calculateAverage(List<XYDataItem> list) {
        double av = 0.0;
        Iterator<XYDataItem> it = list.iterator();
        while (it.hasNext()) {
            av += it.next().getYValue();
        }
        return av / (double)list.size();
    }

    private final double toMBitPerSec(long numberOfBytes, long profilingPeriod) {
        return (double)numberOfBytes / (double)(131072L * profilingPeriod / 1000L);
    }

    public boolean isProfilingEnabledForJob() {
        return this.isProfilingAvailable;
    }
}

