/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.VertexVisualizationData;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import java.util.Map;

public class GroupVertexVisualizationData {
    private static final double CPU_THRESHOLD = 90.0;
    final ManagementGroupVertex managementGroupVertex;
    private boolean cpuBottleneck = false;

    public GroupVertexVisualizationData(ManagementGroupVertex managementGroupVertex) {
        this.managementGroupVertex = managementGroupVertex;
    }

    public boolean isAnySuccessorCPUBottleneck(Map<ManagementGroupVertex, Boolean> successorCPUBottleneckMap) {
        Boolean anySuccessorIsCPUBottleneck = successorCPUBottleneckMap.get(this.managementGroupVertex);
        if (anySuccessorIsCPUBottleneck == null) {
            for (int i = 0; i < this.managementGroupVertex.getNumberOfForwardEdges(); ++i) {
                ManagementGroupVertex targetVertex = this.managementGroupVertex.getForwardEdge(i).getTarget();
                GroupVertexVisualizationData groupVertexVisualizationData = (GroupVertexVisualizationData)targetVertex.getAttachment();
                groupVertexVisualizationData.updateCPUBottleneckFlag(successorCPUBottleneckMap);
                if (!groupVertexVisualizationData.isCPUBottleneck() && !groupVertexVisualizationData.isAnySuccessorCPUBottleneck(successorCPUBottleneckMap)) continue;
                successorCPUBottleneckMap.put(this.managementGroupVertex, true);
                return true;
            }
            successorCPUBottleneckMap.put(this.managementGroupVertex, false);
            return false;
        }
        return anySuccessorIsCPUBottleneck;
    }

    public void updateCPUBottleneckFlag(Map<ManagementGroupVertex, Boolean> successorCPUBottleneckMap) {
        if (this.isAnySuccessorCPUBottleneck(successorCPUBottleneckMap)) {
            this.cpuBottleneck = false;
            return;
        }
        if (this.getAverageUsrTime() < 90.0) {
            this.cpuBottleneck = false;
            return;
        }
        this.cpuBottleneck = true;
    }

    public double getAverageUsrTime() {
        double usrTime = 0.0;
        for (int i = 0; i < this.managementGroupVertex.getNumberOfGroupMembers(); ++i) {
            VertexVisualizationData vertexVisualizationData = (VertexVisualizationData)this.managementGroupVertex.getGroupMember(i).getAttachment();
            usrTime += vertexVisualizationData.getAverageUserTime();
        }
        return usrTime /= (double)this.managementGroupVertex.getNumberOfGroupMembers();
    }

    public boolean isCPUBottleneck() {
        return this.cpuBottleneck;
    }
}

