/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.GateVisualizationData;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import java.util.Map;

public class GroupEdgeVisualizationData {
    private static final double IO_THRESHOLD = 50.0;
    private final ManagementGroupEdge managementGroupEdge;
    private boolean ioBottleneck = false;

    public GroupEdgeVisualizationData(ManagementGroupEdge managementGroupEdge) {
        this.managementGroupEdge = managementGroupEdge;
    }

    public boolean isAnySuccessorIOBottleneck(Map<ManagementGroupEdge, Boolean> successorIOBottleneckMap) {
        Boolean anySuccessorIsIOBottleneck = successorIOBottleneckMap.get(this.managementGroupEdge);
        if (anySuccessorIsIOBottleneck == null) {
            ManagementGroupVertex groupVertex = this.managementGroupEdge.getTarget();
            for (int i = 0; i < groupVertex.getNumberOfForwardEdges(); ++i) {
                ManagementGroupEdge successorEdge = groupVertex.getForwardEdge(i);
                GroupEdgeVisualizationData groupEdgeVisualizationData = (GroupEdgeVisualizationData)successorEdge.getAttachment();
                groupEdgeVisualizationData.updateIOBottleneckFlag(successorIOBottleneckMap);
                if (!groupEdgeVisualizationData.isIOBottleneck() && !groupEdgeVisualizationData.isAnySuccessorIOBottleneck(successorIOBottleneckMap)) continue;
                successorIOBottleneckMap.put(this.managementGroupEdge, true);
                return true;
            }
            successorIOBottleneckMap.put(this.managementGroupEdge, false);
            return false;
        }
        return anySuccessorIsIOBottleneck;
    }

    public void updateIOBottleneckFlag(Map<ManagementGroupEdge, Boolean> successorIOBottleneckMap) {
        if (this.isAnySuccessorIOBottleneck(successorIOBottleneckMap)) {
            this.ioBottleneck = false;
            return;
        }
        if (this.getAverageNumberOfCapacityExhaustions() < 50.0) {
            this.ioBottleneck = false;
            return;
        }
        this.ioBottleneck = true;
    }

    public double getAverageNumberOfCapacityExhaustions() {
        double numberOfCapacityExhaustions = 0.0;
        ManagementGroupVertex sourceVertex = this.managementGroupEdge.getSource();
        for (int i = 0; i < sourceVertex.getNumberOfGroupMembers(); ++i) {
            ManagementVertex vertex = sourceVertex.getGroupMember(i);
            ManagementGate gate = vertex.getOutputGate(this.managementGroupEdge.getSourceIndex());
            GateVisualizationData gateVisulizationData = (GateVisualizationData)gate.getAttachment();
            numberOfCapacityExhaustions += gateVisulizationData.getAverageChartData();
        }
        return numberOfCapacityExhaustions /= (double)sourceVertex.getNumberOfGroupMembers();
    }

    public boolean isIOBottleneck() {
        return this.ioBottleneck;
    }
}

