/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.GroupEdgeVisualizationData;
import eu.stratosphere.addons.visualization.swt.GroupVertexVisualizationData;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.topology.NetworkTopology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GraphVisualizationData {
    private final JobID jobID;
    private final String jobName;
    private final ManagementGraph managementGraph;
    private final NetworkTopology networkTopology;
    private final boolean profilingEnabledForJob;
    private final long submissionTimestamp;

    public GraphVisualizationData(JobID jobID, String jobName, boolean profilingEnabledForJob, long submissionTimestamp, ManagementGraph managementGraph, NetworkTopology networkTopology) {
        this.jobID = jobID;
        this.jobName = jobName;
        this.profilingEnabledForJob = profilingEnabledForJob;
        this.submissionTimestamp = submissionTimestamp;
        this.managementGraph = managementGraph;
        this.networkTopology = networkTopology;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public ManagementGraph getManagementGraph() {
        return this.managementGraph;
    }

    public NetworkTopology getNetworkTopology() {
        return this.networkTopology;
    }

    public boolean isProfilingAvailableForJob() {
        return this.profilingEnabledForJob;
    }

    public long getSubmissionTimestamp() {
        return this.submissionTimestamp;
    }

    public void detectBottlenecks() {
        List reverseTopologicalSort = this.managementGraph.getGroupVerticesInReverseTopologicalOrder();
        HashMap<ManagementGroupVertex, Boolean> successorCPUBottleneckMap = new HashMap<ManagementGroupVertex, Boolean>();
        Iterator it = reverseTopologicalSort.iterator();
        boolean atLeastOneCPUBottleneck = false;
        while (it.hasNext()) {
            ManagementGroupVertex groupVertex = (ManagementGroupVertex)it.next();
            GroupVertexVisualizationData groupVertexVisualizationData = (GroupVertexVisualizationData)groupVertex.getAttachment();
            groupVertexVisualizationData.updateCPUBottleneckFlag(successorCPUBottleneckMap);
            if (!groupVertexVisualizationData.isCPUBottleneck()) continue;
            atLeastOneCPUBottleneck = true;
        }
        if (atLeastOneCPUBottleneck) {
            return;
        }
        it = reverseTopologicalSort.iterator();
        HashMap<ManagementGroupEdge, Boolean> successorIOBottleneckMap = new HashMap<ManagementGroupEdge, Boolean>();
        while (it.hasNext()) {
            ManagementGroupVertex groupVertex = (ManagementGroupVertex)it.next();
            for (int i = 0; i < groupVertex.getNumberOfForwardEdges(); ++i) {
                ManagementGroupEdge groupEdge = groupVertex.getForwardEdge(i);
                GroupEdgeVisualizationData groupEdgeVisualizationData = (GroupEdgeVisualizationData)groupEdge.getAttachment();
                groupEdgeVisualizationData.updateIOBottleneckFlag(successorIOBottleneckMap);
            }
        }
    }
}

