/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.VertexVisualizationData;
import eu.stratosphere.nephele.profiling.types.InputGateProfilingEvent;
import eu.stratosphere.nephele.profiling.types.OutputGateProfilingEvent;
import eu.stratosphere.nephele.profiling.types.ProfilingEvent;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GateVisualizationData {
    private static final double ALPHA = 0.25;
    private final XYSeriesCollection chartCollection;
    private final XYSeries chartSeries;
    private final boolean profilingEnabled;
    private boolean isIOBottleneck = false;
    private double averageChartData = 0.0;

    public GateVisualizationData(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
        if (this.profilingEnabled) {
            this.chartSeries = new XYSeries((Comparable)((Object)"Chart data"), false, false);
            this.chartSeries.setNotify(false);
            this.chartCollection = new XYSeriesCollection(this.chartSeries);
        } else {
            this.chartSeries = null;
            this.chartCollection = null;
        }
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public void processInputGateProfilingEvent(InputGateProfilingEvent inputGateProfilingEvent) {
        double timestamp = VertexVisualizationData.getTimestamp((ProfilingEvent)inputGateProfilingEvent);
        this.addChartData(timestamp, inputGateProfilingEvent.getNoRecordsAvailableCounter());
    }

    public void processOutputGateProfilingEvent(OutputGateProfilingEvent outputGateProfilingEvent) {
        double timestamp = VertexVisualizationData.getTimestamp((ProfilingEvent)outputGateProfilingEvent);
        this.addChartData(timestamp, outputGateProfilingEvent.getChannelCapacityExhausted());
    }

    private void addChartData(double timestamp, double chartData) {
        this.averageChartData = this.averageChartData * 0.75 + chartData * 0.25;
        if (this.chartSeries != null) {
            this.chartSeries.addOrUpdate((Number)timestamp, (Number)chartData);
        }
    }

    public XYDataset getChartCollection() {
        return this.chartCollection;
    }

    public void setIOBottleneck(boolean isIOBottleneck) {
        this.isIOBottleneck = isIOBottleneck;
    }

    public boolean isIOBottleneck() {
        return this.isIOBottleneck;
    }

    public double getAverageChartData() {
        return this.averageChartData;
    }
}

