/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class AutoCompletionCombo
extends Composite
implements KeyListener,
SelectionListener {
    private final ArrayList<String> suggestions;
    private final Combo combo;

    public AutoCompletionCombo(Composite parent, int style, Set<String> suggestions) {
        super(parent, style);
        this.suggestions = new ArrayList<String>(suggestions);
        Collections.sort(this.suggestions);
        this.setLayout((Layout)new FillLayout());
        this.combo = new Combo((Composite)this, style);
        this.combo.addKeyListener((KeyListener)this);
        this.combo.addSelectionListener((SelectionListener)this);
        for (String suggestion : this.suggestions) {
            this.combo.add(suggestion);
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
        if (arg0.character == '\u0000') {
            return;
        }
        String text = this.combo.getText();
        if (text == null) {
            return;
        }
        List<String> matchingSuggestions = this.updateSuggestions(text);
        int length = text.length();
        if (arg0.character == '\b') {
            this.combo.setText(text);
            this.combo.setSelection(new Point(length, length));
        } else if (length != 0) {
            Point selection;
            if (matchingSuggestions.isEmpty()) {
                this.combo.setText(text);
                selection = new Point(length, length);
            } else {
                String suggestion = matchingSuggestions.get(0);
                this.combo.setText(suggestion);
                selection = new Point(length, suggestion.length());
            }
            this.combo.setSelection(selection);
        }
    }

    private List<String> updateSuggestions(String text) {
        ArrayList<String> matchingSuggestions = new ArrayList<String>(this.suggestions.size());
        for (String suggestion : this.suggestions) {
            if (!suggestion.startsWith(text)) continue;
            matchingSuggestions.add(suggestion);
        }
        this.combo.removeAll();
        for (String suggestion : matchingSuggestions) {
            this.combo.add(suggestion);
        }
        return matchingSuggestions;
    }

    public String getText() {
        return this.combo.getText();
    }

    public void setText(String text) {
        this.updateSuggestions(text);
        this.combo.setText(text);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        String text = this.combo.getText();
        this.updateSuggestions(text);
        this.combo.setText(text);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.combo.addKeyListener(keyListener);
    }
}

