/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSWTVertex
extends AbstractSWTComponent {
    private final List<AbstractSWTVertex> edges = new ArrayList<AbstractSWTVertex>();
    private int longestPath = -1;

    protected AbstractSWTVertex(AbstractSWTComponent parent) {
        super(parent);
    }

    Iterator<AbstractSWTVertex> getEdges() {
        return this.edges.iterator();
    }

    public void connectTo(AbstractSWTVertex vertex) {
        if (vertex == null) {
            return;
        }
        if (!this.edges.contains(vertex)) {
            this.edges.add(vertex);
        }
    }

    public int getLongestPathAmongChildren() {
        int longestPath = 0;
        Iterator<AbstractSWTComponent> it = this.getChildren();
        while (it.hasNext()) {
            AbstractSWTComponent child = it.next();
            if (!(child instanceof AbstractSWTVertex)) continue;
            AbstractSWTVertex childVertex = (AbstractSWTVertex)child;
            longestPath = Math.max(longestPath, childVertex.getLongestPath(this));
        }
        return longestPath;
    }

    public int getLongestPath(AbstractSWTVertex parent) {
        if (this.longestPath == -1) {
            int longestPath = 0;
            for (AbstractSWTVertex targetVertex : this.edges) {
                if (targetVertex.getParent() != parent) continue;
                longestPath = Math.max(longestPath, targetVertex.getLongestPath(parent) + 1);
            }
            this.longestPath = longestPath;
        }
        return this.longestPath;
    }

    public int getEdgeSourceX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getEdgeSourceY() {
        return this.getY();
    }

    public int getEdgeTargetX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getEdgeTargetY() {
        return this.getY() + this.getHeight();
    }
}

