/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSWTComponent {
    private final List<AbstractSWTComponent> children = new ArrayList<AbstractSWTComponent>();
    private final AbstractSWTComponent parent;
    protected final Rectangle rect = new Rectangle(0, 0, 0, 0);
    private boolean isVisible = true;

    protected AbstractSWTComponent(AbstractSWTComponent parent) {
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    protected void addChild(AbstractSWTComponent child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public Iterator<AbstractSWTComponent> getChildren() {
        return this.children.iterator();
    }

    public AbstractSWTComponent getChildAt(int index) {
        if (index >= this.children.size()) {
            return null;
        }
        return this.children.get(index);
    }

    public AbstractSWTComponent getParent() {
        return this.parent;
    }

    public int getX() {
        return this.rect.x;
    }

    public void setX(int x) {
        this.rect.x = x;
    }

    public int getY() {
        return this.rect.y;
    }

    public void setY(int y) {
        this.rect.y = y;
    }

    public int getWidth() {
        return this.rect.width;
    }

    public void setWidth(int width) {
        this.rect.width = width;
    }

    public int getHeight() {
        return this.rect.height;
    }

    public void setHeight(int height) {
        this.rect.height = height;
    }

    public abstract void layout();

    public void layoutChildren() {
        for (AbstractSWTComponent child : this.children) {
            child.layout();
        }
    }

    public final void paint(GC gc, Device device) {
        this.paintInternal(gc, device);
        for (AbstractSWTComponent child : this.children) {
            if (!child.isVisible()) continue;
            child.paint(gc, device);
        }
    }

    protected abstract void paintInternal(GC var1, Device var2);

    public AbstractSWTComponent getSelectedComponent(int x, int y) {
        Iterator<AbstractSWTComponent> it = this.getChildren();
        while (it.hasNext()) {
            AbstractSWTComponent child = it.next();
            AbstractSWTComponent selectedComponent = child.getSelectedComponent(x, y);
            if (selectedComponent == null) continue;
            return selectedComponent;
        }
        return this.isSelectable() && this.isWithinComponent(x, y) ? this : null;
    }

    public SWTToolTip constructToolTip(Shell parentShell, SWTToolTipCommandReceiver commandReceiver, int x, int y) {
        return null;
    }

    public boolean isWithinComponent(int x, int y) {
        return this.rect.contains(x, y);
    }

    public abstract boolean isSelectable();

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

