/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.util;

import eu.stratosphere.api.java.record.io.GenericInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;

public class UniformIntInput
extends GenericInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String NUM_KEYS_KEY = "testfomat.numkeys";
    public static final String NUM_VALUES_KEY = "testfomat.numvalues";
    private static final int DEFAULT_NUM_KEYS = 1000;
    private static final int DEFAULT_NUM_VALUES = 1000;
    private final IntValue key = new IntValue();
    private final IntValue value = new IntValue();
    private int numKeys;
    private int numValues;
    private int keyInt;
    private int valueInt;

    public UniformIntInput() {
        this(1000, 1000);
    }

    public UniformIntInput(int numKeys, int numValues) {
        this.numKeys = numKeys;
        this.numValues = numValues;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.numKeys = parameters.getInteger(NUM_KEYS_KEY, this.numKeys);
        this.numValues = parameters.getInteger(NUM_VALUES_KEY, this.numValues);
    }

    public boolean reachedEnd() {
        return this.valueInt >= this.numValues;
    }

    public Record nextRecord(Record record) {
        if (this.keyInt == this.numKeys) {
            this.keyInt = 0;
            ++this.valueInt;
        }
        this.key.setValue(this.keyInt);
        this.value.setValue(this.valueInt);
        record.setField(0, (Value)this.key);
        record.setField(1, (Value)this.value);
        record.updateBinaryRepresenation();
        ++this.keyInt;
        return record;
    }
}

