/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.sort;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.distributions.DataDistribution;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.api.java.record.operators.FileDataSink;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.test.recordJobs.sort.tsUtil.TeraDistribution;
import eu.stratosphere.test.recordJobs.sort.tsUtil.TeraInputFormat;
import eu.stratosphere.test.recordJobs.sort.tsUtil.TeraKey;
import eu.stratosphere.test.recordJobs.sort.tsUtil.TeraOutputFormat;

public final class TeraSort
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public String getDescription() {
        return "Parameters: [numSubStasks] [input] [output]";
    }

    public Plan getPlan(String ... args) throws IllegalArgumentException {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String input = args.length > 1 ? args[1] : "";
        String output = args.length > 2 ? args[2] : "";
        FileDataSource source = new FileDataSource((FileInputFormat)new TeraInputFormat(), input, "Data Source");
        source.setDegreeOfParallelism(numSubTasks);
        FileDataSink sink = new FileDataSink((FileOutputFormat)new TeraOutputFormat(), output, "Data Sink");
        sink.setDegreeOfParallelism(numSubTasks);
        sink.setGlobalOrder(new Ordering(0, TeraKey.class, Order.ASCENDING), (DataDistribution)new TeraDistribution());
        sink.setInput((Operator)source);
        return new Plan((GenericDataSinkBase)sink, "TeraSort");
    }
}

