/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.graph.triangleEnumUtil;

import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;

public final class EdgeWithDegreesInputFormat
extends DelimitedInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String VERTEX_DELIMITER_CHAR = "edgeinput.vertexdelimiter";
    public static final String DEGREE_DELIMITER_CHAR = "edgeinput.degreedelimiter";
    private final IntValue v1 = new IntValue();
    private final IntValue v2 = new IntValue();
    private final IntValue d1 = new IntValue();
    private final IntValue d2 = new IntValue();
    private char vertexDelimiter;
    private char degreeDelimiter;

    public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        int limit = offset + numBytes;
        int firstV = 0;
        int secondV = 0;
        int firstD = 0;
        int secondD = 0;
        char vertexDelimiter = this.vertexDelimiter;
        char degreeDelimiter = this.degreeDelimiter;
        int pos = offset;
        while (pos < limit && bytes[pos] != degreeDelimiter) {
            firstV = firstV * 10 + (bytes[pos++] - 48);
        }
        ++pos;
        while (pos < limit && bytes[pos] != vertexDelimiter) {
            firstD = firstD * 10 + (bytes[pos++] - 48);
        }
        ++pos;
        while (pos < limit && bytes[pos] != degreeDelimiter) {
            secondV = secondV * 10 + (bytes[pos++] - 48);
        }
        ++pos;
        while (pos < limit) {
            secondD = secondD * 10 + (bytes[pos++] - 48);
        }
        if (firstV <= 0 || secondV <= 0 || firstV == secondV) {
            return null;
        }
        this.v1.setValue(firstV);
        this.v2.setValue(secondV);
        this.d1.setValue(firstD);
        this.d2.setValue(secondD);
        target.setField(0, (Value)this.v1);
        target.setField(1, (Value)this.v2);
        target.setField(2, (Value)this.d1);
        target.setField(3, (Value)this.d2);
        return target;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.vertexDelimiter = (char)parameters.getInteger(VERTEX_DELIMITER_CHAR, 124);
        this.degreeDelimiter = (char)parameters.getInteger(DEGREE_DELIMITER_CHAR, 44);
    }
}

