/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.graph.triangleEnumUtil;

import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;

public final class EdgeInputFormat
extends DelimitedInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String ID_DELIMITER_CHAR = "edgeinput.delimiter";
    private final IntValue i1 = new IntValue();
    private final IntValue i2 = new IntValue();
    private char delimiter;

    public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        int limit = offset + numBytes;
        int first = 0;
        int second = 0;
        char delimiter = this.delimiter;
        int pos = offset;
        while (pos < limit && bytes[pos] != delimiter) {
            first = first * 10 + (bytes[pos++] - 48);
        }
        ++pos;
        while (pos < limit) {
            second = second * 10 + (bytes[pos++] - 48);
        }
        if (first <= 0 || second <= 0 || first == second) {
            return null;
        }
        this.i1.setValue(first);
        this.i2.setValue(second);
        target.setField(0, (Value)this.i1);
        target.setField(1, (Value)this.i2);
        return target;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.delimiter = (char)parameters.getInteger(ID_DELIMITER_CHAR, 44);
    }
}

