/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.graph.pageRankUtil;

import eu.stratosphere.types.Value;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PageRankStats
implements Value {
    private static final long serialVersionUID = 1L;
    private double diff;
    private double rank;
    private double danglingRank;
    private long numDanglingVertices;
    private long numVertices;
    private long edges;

    public PageRankStats() {
    }

    public PageRankStats(double diff, double rank, double danglingRank, long numDanglingVertices, long numVertices, long edges) {
        this.diff = diff;
        this.rank = rank;
        this.danglingRank = danglingRank;
        this.numDanglingVertices = numDanglingVertices;
        this.numVertices = numVertices;
        this.edges = edges;
    }

    public double diff() {
        return this.diff;
    }

    public double rank() {
        return this.rank;
    }

    public double danglingRank() {
        return this.danglingRank;
    }

    public long numDanglingVertices() {
        return this.numDanglingVertices;
    }

    public long numVertices() {
        return this.numVertices;
    }

    public long edges() {
        return this.edges;
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.diff);
        out.writeDouble(this.rank);
        out.writeDouble(this.danglingRank);
        out.writeLong(this.numDanglingVertices);
        out.writeLong(this.numVertices);
        out.writeLong(this.edges);
    }

    public void read(DataInput in) throws IOException {
        this.diff = in.readDouble();
        this.rank = in.readDouble();
        this.danglingRank = in.readDouble();
        this.numDanglingVertices = in.readLong();
        this.numVertices = in.readLong();
        this.edges = in.readLong();
    }

    public String toString() {
        return "PageRankStats: diff [" + this.diff + "], rank [" + this.rank + "], danglingRank [" + this.danglingRank + "], numDanglingVertices [" + this.numDanglingVertices + "], numVertices [" + this.numVertices + "], edges [" + this.edges + "]";
    }
}

