/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.graph;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.api.java.record.functions.JoinFunction;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.operators.FileDataSink;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.api.java.record.operators.JoinOperator;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.test.recordJobs.graph.triangleEnumUtil.EdgeWithDegreesInputFormat;
import eu.stratosphere.test.recordJobs.graph.triangleEnumUtil.TriangleOutputFormat;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Iterator;

public class EnumTrianglesOnEdgesWithDegrees
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public Plan getPlan(String ... args) {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String edgeInput = args.length > 1 ? args[1] : "";
        String output = args.length > 2 ? args[2] : "";
        FileDataSource edges = new FileDataSource((FileInputFormat)new EdgeWithDegreesInputFormat(), edgeInput, "Input Edges with Degrees");
        edges.setParameter("edgeinput.vertexdelimiter", 124);
        edges.setParameter("edgeinput.degreedelimiter", 44);
        MapOperator toLowerDegreeEdge = MapOperator.builder((MapFunction)new ProjectToLowerDegreeVertex()).input((Operator)edges).name("Select lower-degree Edge").build();
        MapOperator projectOutCounts = MapOperator.builder((MapFunction)new ProjectOutCounts()).input((Operator)edges).name("Project to vertex Ids only").build();
        ReduceOperator buildTriads = ReduceOperator.builder((ReduceFunction)new BuildTriads(), IntValue.class, (int)0).input((Operator)toLowerDegreeEdge).name("Build Triads").build();
        JoinOperator closeTriads = JoinOperator.builder((JoinFunction)new CloseTriads(), IntValue.class, (int)1, (int)0).keyField(IntValue.class, 2, 1).input1((Operator)buildTriads).input2((Operator)projectOutCounts).name("Close Triads").build();
        closeTriads.setParameter("INPUT_SHIP_STRATEGY", "SHIP_REPARTITION_HASH");
        closeTriads.setParameter("LOCAL_STRATEGY", "LOCAL_STRATEGY_HASH_BUILD_SECOND");
        FileDataSink triangles = new FileDataSink((FileOutputFormat)new TriangleOutputFormat(), output, (Operator)closeTriads, "Triangles");
        Plan p = new Plan((GenericDataSinkBase)triangles, "Enumerate Triangles");
        p.setDefaultParallelism(numSubTasks);
        return p;
    }

    public String getDescription() {
        return "Parameters: [noSubStasks] [input file] [output file]";
    }

    public static class CloseTriads
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void join(Record triangle, Record missingEdge, Collector<Record> out) throws Exception {
            out.collect((Object)triangle);
        }
    }

    public static final class BuildTriads
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IntValue firstVertex = new IntValue();
        private final IntValue secondVertex = new IntValue();
        private int[] edgeCache = new int[1024];

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            int len = 0;
            Record rec = null;
            while (records.hasNext()) {
                rec = records.next();
                int e1 = ((IntValue)rec.getField(1, IntValue.class)).getValue();
                for (int i = 0; i < len; ++i) {
                    int e2 = this.edgeCache[i];
                    if (e1 <= e2) {
                        this.firstVertex.setValue(e1);
                        this.secondVertex.setValue(e2);
                    } else {
                        this.firstVertex.setValue(e2);
                        this.secondVertex.setValue(e1);
                    }
                    rec.setField(1, (Value)this.firstVertex);
                    rec.setField(2, (Value)this.secondVertex);
                    out.collect((Object)rec);
                }
                if (len >= this.edgeCache.length) {
                    int[] na = new int[this.edgeCache.length * 2];
                    System.arraycopy(this.edgeCache, 0, na, 0, this.edgeCache.length);
                    this.edgeCache = na;
                }
                this.edgeCache[len++] = e1;
            }
        }
    }

    public static final class ProjectToLowerDegreeVertex
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            int d2;
            int d1 = ((IntValue)record.getField(2, IntValue.class)).getValue();
            if (d1 > (d2 = ((IntValue)record.getField(3, IntValue.class)).getValue())) {
                IntValue first = (IntValue)record.getField(1, IntValue.class);
                IntValue second = (IntValue)record.getField(0, IntValue.class);
                record.setField(0, (Value)first);
                record.setField(1, (Value)second);
            }
            record.setNumFields(2);
            out.collect((Object)record);
        }
    }

    public static final class ProjectOutCounts
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            record.setNumFields(2);
            out.collect((Object)record);
        }
    }
}

