/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.test.recordJobs.sort.TeraSort;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import org.junit.Assert;

public class TeraSortITCase
extends RecordAPITestBase {
    private static final String INPUT_DATA_FILE = "/testdata/terainput.txt";
    private String resultPath;

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        String testDataPath = ((Object)((Object)this)).getClass().getResource(INPUT_DATA_FILE).toString();
        TeraSort ts = new TeraSort();
        return ts.getPlan("4", testDataPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        File next;
        byte[] line = new byte[100];
        byte[] previous = new byte[10];
        for (int i = 0; i < previous.length; ++i) {
            previous[i] = -128;
        }
        File parent = new File(new URI(this.resultPath).getPath());
        int num = 1;
        while ((next = new File(parent, String.valueOf(num))).exists()) {
            int read;
            FileInputStream inStream = new FileInputStream(next);
            while ((read = inStream.read(line)) == 100) {
                for (int i = 0; i < previous.length && line[i] <= previous[i]; ++i) {
                    if (line[i] >= previous[i]) continue;
                    Assert.fail((String)"Next record is smaller than previous record.");
                }
                System.arraycopy(line, 0, previous, 0, 10);
            }
            if (read != -1) {
                Assert.fail((String)"Inclomplete last record in result file.");
            }
            inStream.close();
            ++num;
        }
        if (num == 1) {
            Assert.fail((String)"Empty result, nothing checked for Job!");
        }
    }
}

