/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.relational.MergeOnlyJoin;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MergeOnlyJoinITCase
extends RecordAPITestBase {
    private String input1Path = null;
    private String input2Path = null;
    private String resultPath = null;
    private final String INPUT1 = "1|9|\n2|8\n3|7\n5|5\n6|4\n7|3\n4|6\n8|2\n2|1\n";
    private final String INPUT2 = "2|2|\n2|6|\n2|1|\n4|1|\n5|1|\n2|1|\n";
    private final String EXPECTED_RESULT = "2|8|2\n2|8|6\n2|8|1\n2|8|1\n2|1|2\n2|1|6\n2|1|1\n2|1|1\n4|6|1\n5|5|1\n";

    public MergeOnlyJoinITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.input1Path = this.createTempFile("input1.txt", "1|9|\n2|8\n3|7\n5|5\n6|4\n7|3\n4|6\n8|2\n2|1\n");
        this.input2Path = this.createTempFile("input2.txt", "2|2|\n2|6|\n2|1|\n4|1|\n5|1|\n2|1|\n");
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        MergeOnlyJoin mergeOnlyJoin = new MergeOnlyJoin();
        return mergeOnlyJoin.getPlan(this.config.getString("MergeOnlyJoinTest#NoSubtasks", "1"), this.input1Path, this.input2Path, this.resultPath, this.config.getString("MergeOnlyJoinTest#NoSubtasksInput2", "1"));
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory("2|8|2\n2|8|6\n2|8|1\n2|8|1\n2|1|2\n2|1|6\n2|1|1\n2|1|1\n4|6|1\n5|5|1\n", this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        ArrayList<Configuration> tConfigs = new ArrayList<Configuration>();
        Configuration config = new Configuration();
        config.setInteger("MergeOnlyJoinTest#NoSubtasks", 3);
        config.setInteger("MergeOnlyJoinTest#NoSubtasksInput2", 3);
        tConfigs.add(config);
        config = new Configuration();
        config.setInteger("MergeOnlyJoinTest#NoSubtasks", 3);
        config.setInteger("MergeOnlyJoinTest#NoSubtasksInput2", 4);
        tConfigs.add(config);
        config = new Configuration();
        config.setInteger("MergeOnlyJoinTest#NoSubtasks", 3);
        config.setInteger("MergeOnlyJoinTest#NoSubtasksInput2", 2);
        tConfigs.add(config);
        return MergeOnlyJoinITCase.toParameterList(tConfigs);
    }
}

