/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.CsvInputFormat;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.operators.FileDataSink;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupOrderReduceITCase
extends RecordAPITestBase {
    private static final String INPUT = "1,3\n2,1\n5,1\n3,1\n1,8\n1,9\n1,2\n2,3\n7,1\n4,2\n2,7\n2,8\n1,1\n2,7\n5,4\n4,3\n3,6\n3,7\n1,3\n2,4\n7,1\n5,3\n4,5\n4,6\n1,4\n3,9\n8,5\n5,3\n5,4\n5,5\n1,7\n3,9\n9,3\n6,2\n6,3\n6,4\n1,8\n3,8\n8,7\n6,2\n7,2\n7,3\n1,1\n3,7\n9,2\n7,1\n8,1\n8,2\n1,2\n2,6\n8,7\n7,1\n9,1\n9,1\n1,1\n2,5\n9,5\n8,2\n10,2\n10,1\n1,1\n2,6\n2,7\n8,3\n11,3\n11,2\n1,2\n2,7\n4,2\n9,4\n12,8\n12,3\n1,2\n4,8\n1,7\n9,5\n13,9\n13,4\n1,3\n4,2\n3,2\n9,6\n14,7\n14,5\n";
    protected String textPath;
    protected String resultPath;

    public GroupOrderReduceITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.textPath = this.createTempFile("pairs.csv", INPUT);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        int dop = this.config.getInteger("GroupOrderTest#NumSubtasks", 1);
        CsvInputFormat format = new CsvInputFormat(',', new Class[]{IntValue.class, IntValue.class});
        FileDataSource source = new FileDataSource((FileInputFormat)format, this.textPath, "Source");
        ReduceOperator reducer = ReduceOperator.builder(CheckingReducer.class).keyField(IntValue.class, 0).input((Operator)source).name("Ordered Reducer").build();
        reducer.setGroupOrder(new Ordering(1, IntValue.class, Order.ASCENDING));
        FileDataSink sink = new FileDataSink(CsvOutputFormat.class, this.resultPath, (Operator)reducer, "Sink");
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)sink).recordDelimiter('\n')).fieldDelimiter(',')).field(IntValue.class, 0)).field(IntValue.class, 1);
        Plan p = new Plan((GenericDataSinkBase)sink);
        p.setDefaultParallelism(dop);
        return p;
    }

    protected void postSubmit() throws Exception {
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config = new Configuration();
        config.setInteger("GroupOrderTest#NumSubtasks", 4);
        return GroupOrderReduceITCase.toParameterList((Configuration[])new Configuration[]{config});
    }

    public static final class CheckingReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            int lastValue = ((IntValue)records.next().getField(1, IntValue.class)).getValue();
            while (records.hasNext()) {
                int nextValue = ((IntValue)records.next().getField(1, IntValue.class)).getValue();
                if (nextValue < lastValue) {
                    throw new Exception("Group Order is violated!");
                }
                lastValue = nextValue;
            }
        }
    }
}

