/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.distributions.DataDistribution;
import eu.stratosphere.api.common.distributions.UniformIntegerDistribution;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.api.java.record.io.CsvInputFormat;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.operators.FileDataSink;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class GlobalSortingITCase
extends RecordAPITestBase {
    private static final int NUM_RECORDS = 100000;
    private String recordsPath;
    private String resultPath;
    private String sortedRecords;

    protected void preSubmit() throws Exception {
        ArrayList<Integer> records = new ArrayList<Integer>();
        Random rnd = new Random(1988L);
        StringBuilder sb = new StringBuilder(700000);
        for (int i = 0; i < 100000; ++i) {
            int number = rnd.nextInt();
            records.add(number);
            sb.append(number);
            sb.append('\n');
        }
        this.recordsPath = this.createTempFile("records", sb.toString());
        this.resultPath = this.getTempDirPath("result");
        Collections.sort(records);
        sb.setLength(0);
        for (Integer i : records) {
            sb.append(i);
            sb.append('\n');
        }
        this.sortedRecords = sb.toString();
    }

    protected Plan getTestJob() {
        GlobalSort globalSort = new GlobalSort();
        return globalSort.getPlan("4", this.recordsPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemoryWithStrictOrder(this.sortedRecords, this.resultPath);
    }

    private static class GlobalSort
    implements Program {
        private static final long serialVersionUID = 1L;

        private GlobalSort() {
        }

        public Plan getPlan(String ... args) throws IllegalArgumentException {
            int numSubtasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
            String recordsPath = args.length > 1 ? args[1] : "";
            String output = args.length > 2 ? args[2] : "";
            FileDataSource source = new FileDataSource(CsvInputFormat.class, recordsPath);
            source.setDegreeOfParallelism(numSubtasks);
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)source).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 0);
            FileDataSink sink = new FileDataSink(CsvOutputFormat.class, output);
            sink.setDegreeOfParallelism(numSubtasks);
            ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)sink).recordDelimiter('\n')).fieldDelimiter('|')).lenient(true)).field(IntValue.class, 0);
            sink.setGlobalOrder(new Ordering(0, IntValue.class, Order.ASCENDING), (DataDistribution)new UniformIntegerDistribution(Integer.MIN_VALUE, Integer.MAX_VALUE));
            sink.setInput((Operator)source);
            return new Plan((GenericDataSinkBase)sink);
        }
    }
}

