/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.graph.EnumTrianglesOnEdgesWithDegrees;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EnumTrianglesOnEdgesWithDegreesITCase
extends RecordAPITestBase {
    private static final String EDGES_WITH_DEGREES = "1,4|2,3\n1,4|3,5\n1,4|4,2\n1,4|5,3\n2,3|3,5\n2,3|5,3\n3,5|4,2\n3,5|7,2\n5,3|6,1\n3,5|8,2\n7,2|8,2\n";
    private static final String EXPECTED = "2,1,3\n4,1,3\n2,1,5\n7,3,8\n";
    protected String edgesPath;
    protected String resultPath;

    public EnumTrianglesOnEdgesWithDegreesITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.edgesPath = this.createTempFile("edgesWithDegrees.txt", EDGES_WITH_DEGREES);
        this.resultPath = this.getTempDirPath("triangles");
    }

    protected Plan getTestJob() {
        EnumTrianglesOnEdgesWithDegrees enumTriangles = new EnumTrianglesOnEdgesWithDegrees();
        return enumTriangles.getPlan(this.config.getString("EnumTrianglesTest#NumSubtasks", "4"), this.edgesPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(EXPECTED, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config = new Configuration();
        config.setInteger("EnumTrianglesTest#NumSubtasks", 4);
        return EnumTrianglesOnEdgesWithDegreesITCase.toParameterList((Configuration[])new Configuration[]{config});
    }
}

