/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.graph.ComputeEdgeDegrees;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ComputeEdgeDegreesITCase
extends RecordAPITestBase {
    protected String edgesPath = null;
    protected String resultPath = null;
    private static final String EDGES = "1,2\n1,3\n1,4\n1,5\n2,3\n2,5\n3,4\n3,7\n4,3\n6,5\n8,3\n7,8\n5,6\n";
    private static final String EXPECTED = "1,4|2,3\n1,4|3,5\n1,4|4,2\n1,4|5,3\n2,3|3,5\n2,3|5,3\n3,5|4,2\n3,5|7,2\n5,3|6,1\n3,5|8,2\n7,2|8,2\n";

    public ComputeEdgeDegreesITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.edgesPath = this.createTempFile("edges.txt", EDGES);
        this.resultPath = this.getTempDirPath("edgesWithDegrees");
    }

    protected Plan getTestJob() {
        ComputeEdgeDegrees computeDegrees = new ComputeEdgeDegrees();
        return computeDegrees.getPlan(this.config.getString("ComputeEdgeDegreesTest#NumSubtasks", "4"), this.edgesPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(EXPECTED, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config = new Configuration();
        config.setInteger("ComputeEdgeDegreesTest#NumSubtasks", 4);
        return ComputeEdgeDegreesITCase.toParameterList((Configuration[])new Configuration[]{config});
    }
}

