/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.java.record.operators.CollectionDataSource;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class CollectionValidationTest {
    @Test
    public void TestArrayInputValidation() throws Exception {
        try {
            new CollectionDataSource("test_1d_valid_array", new Object[]{"a", "b", "c"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            new CollectionDataSource("test_2d_valid_array", (Object[][])new Object[][]{{1, "a"}, {2, "b"}, {3, "c"}});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            new CollectionDataSource("test_1d_invalid_array", new Object[]{1, "b", "c"});
            Assert.fail((String)"input type is different");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new CollectionDataSource("test_2d_invalid_array", (Object[][])new Object[][]{{1, "a"}, {2, "b"}, {3, 4}});
            Assert.fail((String)"input type is different");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void TestCollectionInputValidation() throws Exception {
        ArrayList<Integer> inner;
        int i;
        ArrayList<Object> tmp;
        try {
            tmp = new ArrayList<Object>();
            for (i = 0; i < 100; ++i) {
                tmp.add(i);
            }
            new CollectionDataSource(tmp, "test_valid_collection");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            tmp = new ArrayList();
            for (i = 0; i < 100; ++i) {
                inner = new ArrayList<Integer>();
                inner.add(i);
                inner.add(97 + i);
                tmp.add(inner);
            }
            new CollectionDataSource(tmp, "test_valid_double_collection");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            tmp = new ArrayList();
            for (i = 0; i < 100; ++i) {
                tmp.add(i);
            }
            tmp.add("a");
            new CollectionDataSource(tmp, "test_invalid_collection");
            Assert.fail((String)"input type is different");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            tmp = new ArrayList();
            for (i = 0; i < 100; ++i) {
                inner = new ArrayList();
                inner.add(i);
                inner.add(97 + i);
                tmp.add(inner);
            }
            ArrayList<Character> inner2 = new ArrayList<Character>();
            inner2.add(Character.valueOf('a'));
            inner2.add(Character.valueOf('a'));
            tmp.add(inner2);
            new CollectionDataSource(tmp, "test_invalid_double_collection");
            Assert.fail((String)"input type is different");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

