/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators.io;

import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.api.java.record.io.FileOutputFormat;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContractITCaseIOFormats {
    private static final Log LOG = LogFactory.getLog(ContractITCaseIOFormats.class);

    public static class ContractITCaseOutputFormat
    extends FileOutputFormat {
        private static final long serialVersionUID = 1L;
        private final StringBuilder buffer = new StringBuilder();
        private final StringValue keyString = new StringValue();
        private final IntValue valueInteger = new IntValue();

        public ContractITCaseOutputFormat() {
            this.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        }

        public void writeRecord(Record record) throws IOException {
            this.buffer.setLength(0);
            this.buffer.append(((StringValue)record.getField(0, (Value)this.keyString)).toString());
            this.buffer.append(' ');
            this.buffer.append(((IntValue)record.getField(1, (Value)this.valueInteger)).getValue());
            this.buffer.append('\n');
            byte[] bytes = this.buffer.toString().getBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Writing out: [" + this.keyString.toString() + "," + this.valueInteger.getValue() + "]"));
            }
            this.stream.write(bytes);
        }
    }

    public static class ContractITCaseInputFormat
    extends DelimitedInputFormat {
        private static final long serialVersionUID = 1L;
        private final StringValue keyString = new StringValue();
        private final StringValue valueString = new StringValue();

        public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
            this.keyString.setValueAscii(bytes, offset, 1);
            this.valueString.setValueAscii(bytes, offset + 2, 1);
            target.setField(0, (Value)this.keyString);
            target.setField(1, (Value)this.valueString);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Read in: [" + this.keyString.getValue() + "," + this.valueString.getValue() + "]"));
            }
            return target;
        }
    }
}

