/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.base.FileDataSourceBase;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.api.java.record.operators.FileDataSink;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.operators.io.ContractITCaseIOFormats;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnionITCase
extends RecordAPITestBase {
    private static final Log LOG = LogFactory.getLog(UnionITCase.class);
    String inPath = null;
    String emptyInPath = null;
    String resultPath = null;
    private static final String IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String RESULT = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";
    private static final String EMPTY_RESULT = "";
    private static final String MAP_RESULT_TWICE = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";

    public UnionITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.inPath = this.createTempFile("in.txt", IN);
        this.emptyInPath = this.createTempFile("empty_in.txt", EMPTY_RESULT);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        String input1Path = this.config.getString("UnionTest#Input1Path", EMPTY_RESULT).equals("empty") ? this.emptyInPath : this.inPath;
        String input2Path = this.config.getString("UnionTest#Input2Path", EMPTY_RESULT).equals("empty") ? this.emptyInPath : this.inPath;
        FileDataSource input1 = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), input1Path);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input1).recordDelimiter('\n');
        input1.setDegreeOfParallelism(this.config.getInteger("UnionTest#NoSubtasks", 1));
        FileDataSource input2 = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), input2Path);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input2).recordDelimiter('\n');
        input2.setDegreeOfParallelism(this.config.getInteger("UnionTest#NoSubtasks", 1));
        MapOperator testMapper = MapOperator.builder((MapFunction)new TestMapper()).build();
        testMapper.setDegreeOfParallelism(this.config.getInteger("UnionTest#NoSubtasks", 1));
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setDegreeOfParallelism(1);
        output.setInput((Operator)testMapper);
        testMapper.addInput(new Operator[]{input1});
        testMapper.addInput(new Operator[]{input2});
        return new Plan((GenericDataSinkBase)output);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.config.getString("UnionTest#ExpectedResult", EMPTY_RESULT), this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> testConfigs = new LinkedList<Configuration>();
        Configuration config = new Configuration();
        config.setInteger("UnionTest#NoSubtasks", 4);
        config.setString("UnionTest#ExpectedResult", RESULT);
        config.setString("UnionTest#Input1Path", "non-empty");
        config.setString("UnionTest#Input2Path", "empty");
        testConfigs.add(config);
        config = new Configuration();
        config.setInteger("UnionTest#NoSubtasks", 4);
        config.setString("UnionTest#ExpectedResult", RESULT);
        config.setString("UnionTest#Input1Path", "empty");
        config.setString("UnionTest#Input2Path", "non-empty");
        testConfigs.add(config);
        config = new Configuration();
        config.setInteger("UnionTest#NoSubtasks", 4);
        config.setString("UnionTest#ExpectedResult", MAP_RESULT_TWICE);
        config.setString("UnionTest#Input1Path", "non-empty");
        config.setString("UnionTest#Input2Path", "non-empty");
        testConfigs.add(config);
        config = new Configuration();
        config.setInteger("UnionTest#NoSubtasks", 4);
        config.setString("UnionTest#ExpectedResult", EMPTY_RESULT);
        config.setString("UnionTest#Input1Path", "empty");
        config.setString("UnionTest#Input2Path", "empty");
        testConfigs.add(config);
        return UnionITCase.toParameterList(testConfigs);
    }

    public static class TestMapper
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue keyString = new StringValue();
        private StringValue valueString = new StringValue();

        public void map(Record record, Collector<Record> out) throws Exception {
            this.keyString = (StringValue)record.getField(0, (Value)this.keyString);
            this.valueString = (StringValue)record.getField(1, (Value)this.valueString);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processed: [" + this.keyString.toString() + "," + this.valueString.getValue() + "]"));
            }
            if (Integer.parseInt(this.keyString.toString()) + Integer.parseInt(this.valueString.toString()) < 10) {
                record.setField(0, (Value)this.valueString);
                record.setField(1, (Value)new IntValue(Integer.parseInt(this.keyString.toString()) + 10));
                out.collect((Object)record);
            }
        }
    }
}

