/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.operators.ProjectOperator;
import eu.stratosphere.api.java.tuple.Tuple5;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProjectITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 1;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public ProjectITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = ProjectProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return ProjectITCase.toParameterList(tConfigs);
    }

    private static class ProjectProgs {
        private ProjectProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.get5TupleDataSet(env);
                    ProjectOperator projDs = ds.project(new int[]{3, 4, 2}).types(String.class, Long.class, Integer.class);
                    projDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hallo,1,0\nHallo Welt,2,1\nHallo Welt wie,1,2\nHallo Welt wie gehts?,2,3\nABC,2,4\nBCD,3,5\nCDE,2,6\nDEF,1,7\nEFG,1,8\nFGH,2,9\nGHI,1,10\nHIJ,3,11\nIJK,3,12\nJKL,2,13\nKLM,2,14\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

