/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.FilterFunction;
import eu.stratosphere.api.java.operators.FilterOperator;
import eu.stratosphere.api.java.operators.SingleInputUdfOperator;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FilterITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 8;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public FilterITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = FilterProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return FilterITCase.toParameterList(tConfigs);
    }

    private static class FilterProgs {
        private FilterProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FilterOperator filterDs = ds.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return false;
                        }
                    });
                    filterDs.writeAsCsv(resultPath);
                    env.execute();
                    return "\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FilterOperator filterDs = ds.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return true;
                        }
                    });
                    filterDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FilterOperator filterDs = ds.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return ((String)value.f2).contains("world");
                        }
                    });
                    filterDs.writeAsCsv(resultPath);
                    env.execute();
                    return "3,2,Hello world\n4,3,Hello world, how are you?\n";
                }
                case 4: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FilterOperator filterDs = ds.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return (Integer)value.f0 % 2 == 0;
                        }
                    });
                    filterDs.writeAsCsv(resultPath);
                    env.execute();
                    return "2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n";
                }
                case 5: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
                    FilterOperator filterDs = ds.filter((FilterFunction)new FilterFunction<String>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(String value) throws Exception {
                            return value.startsWith("H");
                        }
                    });
                    filterDs.writeAsText(resultPath);
                    env.execute();
                    return "Hi\nHello\nHello world\nHello world, how are you?\n";
                }
                case 6: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
                    FilterOperator filterDs = ds.filter((FilterFunction)new FilterFunction<CollectionDataSets.CustomType>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(CollectionDataSets.CustomType value) throws Exception {
                            return value.myString.contains("a");
                        }
                    });
                    filterDs.writeAsText(resultPath);
                    env.execute();
                    return "3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n";
                }
                case 7: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Integer> ints = CollectionDataSets.getIntegerDataSet(env);
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    SingleInputUdfOperator filterDs = ds.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;
                        int literal = -1;

                        public void open(Configuration config) {
                            Collection ints = this.getRuntimeContext().getBroadcastVariable("ints");
                            Iterator iterator = ints.iterator();
                            while (iterator.hasNext()) {
                                int i = (Integer)iterator.next();
                                this.literal = this.literal < i ? i : this.literal;
                            }
                        }

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return (Integer)value.f0 < this.literal;
                        }
                    }).withBroadcastSet(ints, "ints");
                    filterDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n";
                }
                case 8: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Integer> intDs = CollectionDataSets.getIntegerDataSet(env);
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    SingleInputUdfOperator filterDs = ds.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;
                        private int broadcastSum = 0;

                        public void open(Configuration config) {
                            Collection ints = this.getRuntimeContext().getBroadcastVariable("ints");
                            for (Integer i : ints) {
                                this.broadcastSum += i.intValue();
                            }
                        }

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return (Long)value.f1 == (long)(this.broadcastSum / 11);
                        }
                    }).withBroadcastSet(intDs, "ints");
                    filterDs.writeAsCsv(resultPath);
                    env.execute();
                    return "11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

