/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.aggregation.Aggregations;
import eu.stratosphere.api.java.operators.ProjectOperator;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AggregateITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 3;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public AggregateITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = AggregateProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return AggregateITCase.toParameterList(tConfigs);
    }

    private static class AggregateProgs {
        private AggregateProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    ProjectOperator aggregateDs = ds.aggregate(Aggregations.SUM, 0).and(Aggregations.MAX, 1).project(new int[]{0, 1}).types(Integer.class, Long.class);
                    aggregateDs.writeAsCsv(resultPath);
                    env.execute();
                    return "231,6\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.SUM, 0).project(new int[]{1, 0}).types(Long.class, Integer.class);
                    aggregateDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1\n2,5\n3,15\n4,34\n5,65\n6,111\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.MIN, 0).aggregate(Aggregations.MIN, 0).project(new int[]{0}).types(Integer.class);
                    aggregateDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

