/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.danglingpagerank;

import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.iterative.nephele.ConfigUtils;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.PageRankStats;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.util.Set;

public class CompensatingMap
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private int workerIndex;
    private int currentIteration;
    private long numVertices;
    private int failingIteration;
    private Set<Integer> failingWorkers;
    private double uniformRank;
    private double rescaleFactor;
    private DoubleValue rank = new DoubleValue();

    public void open(Configuration parameters) {
        this.workerIndex = this.getRuntimeContext().getIndexOfThisSubtask();
        this.currentIteration = this.getIterationRuntimeContext().getSuperstepNumber();
        this.failingIteration = ConfigUtils.asInteger("compensation.failingIteration", parameters);
        this.failingWorkers = ConfigUtils.asIntSet("compensation.failingWorker", parameters);
        this.numVertices = ConfigUtils.asLong("pageRank.numVertices", parameters);
        if (this.currentIteration > 1) {
            PageRankStats stats = (PageRankStats)this.getIterationRuntimeContext().getPreviousIterationAggregate("pagerank.aggregator");
            this.uniformRank = 1.0 / (double)this.numVertices;
            double lostMassFactor = (double)(this.numVertices - stats.numVertices()) / (double)this.numVertices;
            this.rescaleFactor = (1.0 - lostMassFactor) / stats.rank();
        }
    }

    public void map(Record pageWithRank, Collector<Record> out) {
        if (this.currentIteration == this.failingIteration + 1) {
            this.rank = (DoubleValue)pageWithRank.getField(1, (Value)this.rank);
            if (this.failingWorkers.contains(this.workerIndex)) {
                this.rank.setValue(this.uniformRank);
            } else {
                this.rank.setValue(this.rank.getValue() * this.rescaleFactor);
            }
            pageWithRank.setField(1, (Value)this.rank);
        }
        out.collect((Object)pageWithRank);
    }
}

