/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.danglingpagerank;

import eu.stratosphere.api.common.operators.util.UserCodeClassWrapper;
import eu.stratosphere.api.common.operators.util.UserCodeWrapper;
import eu.stratosphere.api.common.typeutils.TypeComparatorFactory;
import eu.stratosphere.api.common.typeutils.TypePairComparatorFactory;
import eu.stratosphere.api.common.typeutils.TypeSerializerFactory;
import eu.stratosphere.api.java.typeutils.runtime.record.RecordComparatorFactory;
import eu.stratosphere.api.java.typeutils.runtime.record.RecordPairComparatorFactory;
import eu.stratosphere.api.java.typeutils.runtime.record.RecordSerializerFactory;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.nephele.jobgraph.AbstractJobVertex;
import eu.stratosphere.nephele.jobgraph.DistributionPattern;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.nephele.jobgraph.JobInputVertex;
import eu.stratosphere.nephele.jobgraph.JobOutputVertex;
import eu.stratosphere.nephele.jobgraph.JobTaskVertex;
import eu.stratosphere.pact.runtime.iterative.task.IterationHeadPactTask;
import eu.stratosphere.pact.runtime.iterative.task.IterationIntermediatePactTask;
import eu.stratosphere.pact.runtime.iterative.task.IterationTailPactTask;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.BuildSecondCachedMatchDriver;
import eu.stratosphere.pact.runtime.task.CoGroupDriver;
import eu.stratosphere.pact.runtime.task.CollectorMapDriver;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.runtime.io.channels.ChannelType;
import eu.stratosphere.test.iterative.nephele.JobGraphUtils;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.CompensatableDotProductCoGroup;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.CompensatableDotProductMatch;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.CompensatingMap;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.DiffL1NormConvergenceCriterion;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.ImprovedAdjacencyListInputFormat;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.ImprovedDanglingPageRankInputFormat;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.PageRankStatsAggregator;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.PageWithRankOutFormat;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.util.OperatingSystem;

public class CompensatableDanglingPageRank {
    private static final TypeSerializerFactory<?> recSerializer = RecordSerializerFactory.get();
    private static final TypeComparatorFactory<?> fieldZeroComparator = new RecordComparatorFactory(new int[]{0}, new Class[]{LongValue.class}, new boolean[]{true});
    private static final TypePairComparatorFactory<?, ?> pairComparatorFactory = new RecordPairComparatorFactory();
    private static final int NUM_FILE_HANDLES_PER_SORT = 64;
    private static final float SORT_SPILL_THRESHOLD = 0.85f;
    private static final int ITERATION_ID = 1;

    public static JobGraph getJobGraph(String[] args) throws Exception {
        int degreeOfParallelism;
        int numSubTasksPerInstance = degreeOfParallelism = 2;
        String pageWithRankInputPath = "";
        String adjacencyListInputPath = "";
        String outputPath = OperatingSystem.isWindows() ? "file:/c:/tmp/stratosphere/iterations" : "file:///tmp/stratosphere/iterations";
        int minorConsumer = 25;
        int matchMemory = 50;
        int coGroupSortMemory = 50;
        int numIterations = 25;
        long numVertices = 5L;
        long numDanglingVertices = 1L;
        String failingWorkers = "1";
        int failingIteration = 2;
        double messageLoss = 0.75;
        if (args.length >= 15) {
            degreeOfParallelism = Integer.parseInt(args[0]);
            numSubTasksPerInstance = Integer.parseInt(args[1]);
            pageWithRankInputPath = args[2];
            adjacencyListInputPath = args[3];
            outputPath = args[4];
            minorConsumer = Integer.parseInt(args[6]);
            matchMemory = Integer.parseInt(args[7]);
            coGroupSortMemory = Integer.parseInt(args[8]);
            numIterations = Integer.parseInt(args[9]);
            numVertices = Long.parseLong(args[10]);
            numDanglingVertices = Long.parseLong(args[11]);
            failingWorkers = args[12];
            failingIteration = Integer.parseInt(args[13]);
            messageLoss = Double.parseDouble(args[14]);
        }
        JobGraph jobGraph = new JobGraph("CompensatableDanglingPageRank");
        JobInputVertex pageWithRankInput = JobGraphUtils.createInput(new ImprovedDanglingPageRankInputFormat(), pageWithRankInputPath, "DanglingPageWithRankInput", jobGraph, degreeOfParallelism, numSubTasksPerInstance);
        TaskConfig pageWithRankInputConfig = new TaskConfig(pageWithRankInput.getConfiguration());
        pageWithRankInputConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        pageWithRankInputConfig.setOutputComparator(fieldZeroComparator, 0);
        pageWithRankInputConfig.setOutputSerializer(recSerializer);
        pageWithRankInputConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        JobInputVertex adjacencyListInput = JobGraphUtils.createInput(new ImprovedAdjacencyListInputFormat(), adjacencyListInputPath, "AdjancencyListInput", jobGraph, degreeOfParallelism, numSubTasksPerInstance);
        TaskConfig adjacencyListInputConfig = new TaskConfig(adjacencyListInput.getConfiguration());
        adjacencyListInputConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        adjacencyListInputConfig.setOutputSerializer(recSerializer);
        adjacencyListInputConfig.setOutputComparator(fieldZeroComparator, 0);
        JobTaskVertex head = JobGraphUtils.createTask(IterationHeadPactTask.class, "IterationHead", jobGraph, degreeOfParallelism, numSubTasksPerInstance);
        TaskConfig headConfig = new TaskConfig(head.getConfiguration());
        headConfig.setIterationId(1);
        headConfig.addInputToGroup(0);
        headConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(0);
        headConfig.setInputSerializer(recSerializer, 0);
        headConfig.setInputComparator(fieldZeroComparator, 0);
        headConfig.setInputLocalStrategy(0, LocalStrategy.SORT);
        headConfig.setMemoryInput(0, (long)minorConsumer * 0x100000L);
        headConfig.setFilehandlesInput(0, 64);
        headConfig.setSpillingThresholdInput(0, 0.85f);
        headConfig.setBackChannelMemory((long)minorConsumer * 0x100000L);
        headConfig.setOutputSerializer(recSerializer);
        headConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        headConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        TaskConfig headFinalOutConfig = new TaskConfig(new Configuration());
        headFinalOutConfig.setOutputSerializer(recSerializer);
        headFinalOutConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        headConfig.setIterationHeadFinalOutputConfig(headFinalOutConfig);
        headConfig.setIterationHeadIndexOfSyncOutput(3);
        headConfig.setNumberOfIterations(numIterations);
        headConfig.setDriver(CollectorMapDriver.class);
        headConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        headConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CompensatingMap.class));
        headConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        headConfig.setStubParameter("compensation.failingWorker", failingWorkers);
        headConfig.setStubParameter("compensation.failingIteration", String.valueOf(failingIteration));
        headConfig.setStubParameter("compensation.messageLoss", String.valueOf(messageLoss));
        headConfig.addIterationAggregator("pagerank.aggregator", PageRankStatsAggregator.class);
        JobTaskVertex intermediate = JobGraphUtils.createTask(IterationIntermediatePactTask.class, "IterationIntermediate", jobGraph, degreeOfParallelism, numSubTasksPerInstance);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        intermediateConfig.setIterationId(1);
        intermediateConfig.setDriver(BuildSecondCachedMatchDriver.class);
        intermediateConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        intermediateConfig.setMemoryDriver((long)matchMemory * 0x100000L);
        intermediateConfig.addInputToGroup(0);
        intermediateConfig.addInputToGroup(1);
        intermediateConfig.setInputSerializer(recSerializer, 0);
        intermediateConfig.setInputSerializer(recSerializer, 1);
        intermediateConfig.setDriverComparator(fieldZeroComparator, 0);
        intermediateConfig.setDriverComparator(fieldZeroComparator, 1);
        intermediateConfig.setDriverPairComparator(pairComparatorFactory);
        intermediateConfig.setOutputSerializer(recSerializer);
        intermediateConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        intermediateConfig.setOutputComparator(fieldZeroComparator, 0);
        intermediateConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CompensatableDotProductMatch.class));
        intermediateConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        intermediateConfig.setStubParameter("compensation.failingWorker", failingWorkers);
        intermediateConfig.setStubParameter("compensation.failingIteration", String.valueOf(failingIteration));
        intermediateConfig.setStubParameter("compensation.messageLoss", String.valueOf(messageLoss));
        JobTaskVertex tail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationTail", jobGraph, degreeOfParallelism, numSubTasksPerInstance);
        TaskConfig tailConfig = new TaskConfig(tail.getConfiguration());
        tailConfig.setIterationId(1);
        tailConfig.setIsWorksetUpdate();
        tailConfig.setDriver(CoGroupDriver.class);
        tailConfig.setDriverStrategy(DriverStrategy.CO_GROUP);
        tailConfig.addInputToGroup(0);
        tailConfig.addInputToGroup(1);
        tailConfig.setInputSerializer(recSerializer, 0);
        tailConfig.setInputSerializer(recSerializer, 1);
        tailConfig.setDriverComparator(fieldZeroComparator, 0);
        tailConfig.setDriverComparator(fieldZeroComparator, 1);
        tailConfig.setDriverPairComparator(pairComparatorFactory);
        tailConfig.setInputAsynchronouslyMaterialized(0, true);
        tailConfig.setInputMaterializationMemory(0, (long)minorConsumer * 0x100000L);
        tailConfig.setInputLocalStrategy(1, LocalStrategy.SORT);
        tailConfig.setInputComparator(fieldZeroComparator, 1);
        tailConfig.setMemoryInput(1, (long)coGroupSortMemory * 0x100000L);
        tailConfig.setFilehandlesInput(1, 64);
        tailConfig.setSpillingThresholdInput(1, 0.85f);
        tailConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        tailConfig.setOutputSerializer(recSerializer);
        tailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CompensatableDotProductCoGroup.class));
        tailConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        tailConfig.setStubParameter("pageRank.numDanglingVertices", String.valueOf(numDanglingVertices));
        tailConfig.setStubParameter("compensation.failingWorker", failingWorkers);
        tailConfig.setStubParameter("compensation.failingIteration", String.valueOf(failingIteration));
        tailConfig.setStubParameter("compensation.messageLoss", String.valueOf(messageLoss));
        JobOutputVertex output = JobGraphUtils.createFileOutput(jobGraph, "FinalOutput", degreeOfParallelism, numSubTasksPerInstance);
        TaskConfig outputConfig = new TaskConfig(output.getConfiguration());
        outputConfig.addInputToGroup(0);
        outputConfig.setInputSerializer(recSerializer, 0);
        outputConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(PageWithRankOutFormat.class));
        outputConfig.setStubParameter("stratosphere.output.file", outputPath);
        JobOutputVertex fakeTailOutput = JobGraphUtils.createFakeOutput(jobGraph, "FakeTailOutput", degreeOfParallelism, numSubTasksPerInstance);
        JobOutputVertex sync = JobGraphUtils.createSync(jobGraph, degreeOfParallelism);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setNumberOfIterations(numIterations);
        syncConfig.addIterationAggregator("pagerank.aggregator", PageRankStatsAggregator.class);
        syncConfig.setConvergenceCriterion("pagerank.aggregator", DiffL1NormConvergenceCriterion.class);
        syncConfig.setIterationId(1);
        JobGraphUtils.connect((AbstractJobVertex)pageWithRankInput, (AbstractJobVertex)head, ChannelType.NETWORK, DistributionPattern.BIPARTITE);
        JobGraphUtils.connect((AbstractJobVertex)head, (AbstractJobVertex)intermediate, ChannelType.IN_MEMORY, DistributionPattern.POINTWISE);
        intermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect((AbstractJobVertex)adjacencyListInput, (AbstractJobVertex)intermediate, ChannelType.NETWORK, DistributionPattern.BIPARTITE);
        JobGraphUtils.connect((AbstractJobVertex)head, (AbstractJobVertex)tail, ChannelType.NETWORK, DistributionPattern.POINTWISE);
        JobGraphUtils.connect((AbstractJobVertex)intermediate, (AbstractJobVertex)tail, ChannelType.NETWORK, DistributionPattern.BIPARTITE);
        tailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        tailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(1, degreeOfParallelism);
        JobGraphUtils.connect((AbstractJobVertex)head, (AbstractJobVertex)output, ChannelType.IN_MEMORY, DistributionPattern.POINTWISE);
        JobGraphUtils.connect((AbstractJobVertex)tail, (AbstractJobVertex)fakeTailOutput, ChannelType.IN_MEMORY, DistributionPattern.POINTWISE);
        JobGraphUtils.connect((AbstractJobVertex)head, (AbstractJobVertex)sync, ChannelType.NETWORK, DistributionPattern.POINTWISE);
        fakeTailOutput.setVertexToShareInstancesWith((AbstractJobVertex)tail);
        tail.setVertexToShareInstancesWith((AbstractJobVertex)head);
        pageWithRankInput.setVertexToShareInstancesWith((AbstractJobVertex)head);
        adjacencyListInput.setVertexToShareInstancesWith((AbstractJobVertex)head);
        intermediate.setVertexToShareInstancesWith((AbstractJobVertex)head);
        output.setVertexToShareInstancesWith((AbstractJobVertex)head);
        sync.setVertexToShareInstancesWith((AbstractJobVertex)head);
        return jobGraph;
    }
}

