/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.customdanglingpagerank.types;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.test.iterative.nephele.customdanglingpagerank.types.VertexWithRank;
import java.io.IOException;

public final class VertexWithRankComparator
extends TypeComparator<VertexWithRank> {
    private static final long serialVersionUID = 1L;
    private long reference;

    public int hash(VertexWithRank record) {
        long value = record.getVertexID();
        return 43 + (int)(value ^ value >>> 32);
    }

    public void setReference(VertexWithRank toCompare) {
        this.reference = toCompare.getVertexID();
    }

    public boolean equalToReference(VertexWithRank candidate) {
        return candidate.getVertexID() == this.reference;
    }

    public int compareToReference(TypeComparator<VertexWithRank> referencedComparator) {
        VertexWithRankComparator comp = (VertexWithRankComparator)referencedComparator;
        long diff = comp.reference - this.reference;
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public int compare(VertexWithRank first, VertexWithRank second) {
        long diff = first.getVertexID() - second.getVertexID();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public int compare(DataInputView source1, DataInputView source2) throws IOException {
        long diff = source1.readLong() - source2.readLong();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public boolean supportsNormalizedKey() {
        return true;
    }

    public int getNormalizeKeyLen() {
        return 8;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 8;
    }

    public void putNormalizedKey(VertexWithRank record, MemorySegment target, int offset, int len) {
        block5: {
            long value;
            block4: {
                value = record.getVertexID() - Long.MIN_VALUE;
                if (len != 8) break block4;
                target.putLongBigEndian(offset, value);
                break block5;
            }
            if (len <= 0) break block5;
            if (len < 8) {
                int i = 0;
                while (len > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3) & 0xFFL));
                    --len;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, value);
                for (int i = 8; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return true;
    }

    public void writeWithKeyNormalization(VertexWithRank record, DataOutputView target) throws IOException {
        target.writeLong(record.getVertexID() - Long.MIN_VALUE);
        target.writeDouble(record.getRank());
    }

    public VertexWithRank readWithKeyDenormalization(VertexWithRank reuse, DataInputView source) throws IOException {
        reuse.setVertexID(source.readLong() + Long.MIN_VALUE);
        reuse.setRank(source.readDouble());
        return reuse;
    }

    public VertexWithRankComparator duplicate() {
        return new VertexWithRankComparator();
    }
}

