/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.customdanglingpagerank.types;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.test.iterative.nephele.customdanglingpagerank.types.VertexWithAdjacencyList;
import java.io.IOException;

public final class VertexWithAdjacencyListSerializer
extends TypeSerializer<VertexWithAdjacencyList> {
    private static final long serialVersionUID = 1L;

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public VertexWithAdjacencyList createInstance() {
        return new VertexWithAdjacencyList();
    }

    public VertexWithAdjacencyList copy(VertexWithAdjacencyList from, VertexWithAdjacencyList reuse) {
        if (reuse.getTargets().length < from.getTargets().length) {
            reuse.setTargets(new long[from.getTargets().length]);
        }
        reuse.setVertexID(from.getVertexID());
        reuse.setNumTargets(from.getNumTargets());
        System.arraycopy(from.getTargets(), 0, reuse.getTargets(), 0, from.getNumTargets());
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(VertexWithAdjacencyList record, DataOutputView target) throws IOException {
        target.writeLong(record.getVertexID());
        long[] targets = record.getTargets();
        int numTargets = record.getNumTargets();
        target.writeInt(numTargets);
        for (int i = 0; i < numTargets; ++i) {
            target.writeLong(targets[i]);
        }
    }

    public VertexWithAdjacencyList deserialize(VertexWithAdjacencyList target, DataInputView source) throws IOException {
        target.setVertexID(source.readLong());
        int numTargets = source.readInt();
        long[] targets = target.getTargets();
        if (targets.length < numTargets) {
            targets = new long[numTargets];
            target.setTargets(targets);
        }
        target.setNumTargets(numTargets);
        for (int i = 0; i < numTargets; ++i) {
            targets[i] = source.readLong();
        }
        return target;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 8);
        int numTargets = source.readInt();
        target.writeInt(numTargets);
        target.write(source, numTargets * 8);
    }

    public int hashCode() {
        return 3;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == VertexWithAdjacencyListSerializer.class;
    }
}

