/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler.iterations;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.operators.base.GenericDataSourceBase;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.compiler.plan.BulkIterationPlanNode;
import eu.stratosphere.compiler.plan.NamedChannel;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import eu.stratosphere.test.compiler.util.CompilerTestBase;
import eu.stratosphere.test.compiler.util.OperatorResolver;
import eu.stratosphere.test.recordJobs.kmeans.KMeansBroadcast;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class IterativeKMeansTest
extends CompilerTestBase {
    private static final String DATAPOINTS = "Data Points";
    private static final String CENTERS = "Centers";
    private static final String MAPPER_NAME = "Find Nearest Centers";
    private static final String REDUCER_NAME = "Recompute Center Positions";
    private static final String ITERATION_NAME = "k-means loop";
    private static final String SINK = "New Center Positions";
    private final FieldList set0 = new FieldList(0);

    @Test
    public void testCompileKMeansSingleStepWithStats() {
        KMeansBroadcast kmi = new KMeansBroadcast();
        Plan p = kmi.getPlan(String.valueOf(8), IN_FILE, IN_FILE, OUT_FILE, String.valueOf(20));
        OperatorResolver cr = IterativeKMeansTest.getContractResolver((Plan)p);
        FileDataSource pointsSource = (FileDataSource)cr.getNode(DATAPOINTS);
        FileDataSource centersSource = (FileDataSource)cr.getNode(CENTERS);
        this.setSourceStatistics((GenericDataSourceBase)pointsSource, 0x1900000000L, 32.0f);
        this.setSourceStatistics((GenericDataSourceBase)centersSource, 0x100000L, 32.0f);
        OptimizedPlan plan = this.compileWithStats(p);
        this.checkPlan(plan);
        new NepheleJobGraphGenerator().compileJobGraph(plan);
    }

    @Test
    public void testCompileKMeansSingleStepWithOutStats() {
        KMeansBroadcast kmi = new KMeansBroadcast();
        Plan p = kmi.getPlan(String.valueOf(8), IN_FILE, IN_FILE, OUT_FILE, String.valueOf(20));
        OptimizedPlan plan = this.compileNoStats(p);
        this.checkPlan(plan);
        new NepheleJobGraphGenerator().compileJobGraph(plan);
    }

    private void checkPlan(OptimizedPlan plan) {
        CompilerTestBase.OptimizerPlanNodeResolver or = IterativeKMeansTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
        SinkPlanNode sink = (SinkPlanNode)or.getNode(SINK);
        SingleInputPlanNode reducer = (SingleInputPlanNode)or.getNode(REDUCER_NAME);
        SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getPredecessor();
        SingleInputPlanNode mapper = (SingleInputPlanNode)or.getNode(MAPPER_NAME);
        BulkIterationPlanNode iter = (BulkIterationPlanNode)or.getNode(ITERATION_NAME);
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)sink.getInput().getLocalStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)iter.getInput().getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)iter.getInput().getLocalStrategy());
        Assert.assertEquals((long)1L, (long)mapper.getBroadcastInputs().size());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)mapper.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.BROADCAST, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getShipStrategy());
        Assert.assertFalse((boolean)mapper.getInput().isOnDynamicPath());
        Assert.assertTrue((boolean)((NamedChannel)mapper.getBroadcastInputs().get(0)).isOnDynamicPath());
        Assert.assertTrue((boolean)mapper.getInput().getTempMode().isCached());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)mapper.getInput().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getLocalStrategy());
        Assert.assertEquals((Object)DriverStrategy.COLLECTOR_MAP, (Object)mapper.getDriverStrategy());
        Assert.assertNull((Object)mapper.getInput().getLocalStrategyKeys());
        Assert.assertNull((Object)mapper.getInput().getLocalStrategySortOrder());
        Assert.assertNull((Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getLocalStrategyKeys());
        Assert.assertNull((Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getLocalStrategySortOrder());
        Assert.assertNotNull((Object)combiner);
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        Assert.assertTrue((boolean)combiner.getInput().isOnDynamicPath());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)combiner.getInput().getLocalStrategy());
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
        Assert.assertNull((Object)combiner.getInput().getLocalStrategyKeys());
        Assert.assertNull((Object)combiner.getInput().getLocalStrategySortOrder());
        Assert.assertEquals((Object)this.set0, (Object)combiner.getKeys());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)reducer.getInput().getShipStrategy());
        Assert.assertTrue((boolean)reducer.getInput().isOnDynamicPath());
        Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer.getInput().getLocalStrategy());
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_REDUCE, (Object)reducer.getDriverStrategy());
        Assert.assertEquals((Object)this.set0, (Object)reducer.getKeys());
        Assert.assertEquals((Object)this.set0, (Object)reducer.getInput().getLocalStrategyKeys());
        Assert.assertTrue((boolean)Arrays.equals(reducer.getInput().getLocalStrategySortOrder(), reducer.getSortOrders()));
    }
}

