/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler.iterations;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.compiler.dag.TempMode;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.compiler.plan.SourcePlanNode;
import eu.stratosphere.compiler.plan.WorksetIterationPlanNode;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import eu.stratosphere.test.compiler.util.CompilerTestBase;
import eu.stratosphere.test.recordJobs.graph.ConnectedComponentsWithCoGroup;
import org.junit.Assert;
import org.junit.Test;

public class ConnectedComponentsCoGroupTest
extends CompilerTestBase {
    private static final String VERTEX_SOURCE = "Vertices";
    private static final String ITERATION_NAME = "Connected Components Iteration";
    private static final String EDGES_SOURCE = "Edges";
    private static final String JOIN_NEIGHBORS_MATCH = "Join Candidate Id With Neighbor";
    private static final String MIN_ID_AND_UPDATE = "Min Id and Update";
    private static final String SINK = "Result";
    private static final boolean PRINT_PLAN = false;
    private final FieldList set0 = new FieldList(0);

    @Test
    public void testWorksetConnectedComponents() {
        ConnectedComponentsWithCoGroup cc = new ConnectedComponentsWithCoGroup();
        Plan plan = cc.getPlan(String.valueOf(8), IN_FILE, IN_FILE, OUT_FILE, String.valueOf(100));
        OptimizedPlan optPlan = this.compileNoStats(plan);
        CompilerTestBase.OptimizerPlanNodeResolver or = ConnectedComponentsCoGroupTest.getOptimizerPlanNodeResolver((OptimizedPlan)optPlan);
        SourcePlanNode vertexSource = (SourcePlanNode)or.getNode(VERTEX_SOURCE);
        SourcePlanNode edgesSource = (SourcePlanNode)or.getNode(EDGES_SOURCE);
        SinkPlanNode sink = (SinkPlanNode)or.getNode(SINK);
        WorksetIterationPlanNode iter = (WorksetIterationPlanNode)or.getNode(ITERATION_NAME);
        DualInputPlanNode neighborsJoin = (DualInputPlanNode)or.getNode(JOIN_NEIGHBORS_MATCH);
        DualInputPlanNode cogroup = (DualInputPlanNode)or.getNode(MIN_ID_AND_UPDATE);
        Assert.assertEquals((Object)DriverStrategy.NONE, (Object)sink.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.NONE, (Object)vertexSource.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.NONE, (Object)edgesSource.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.MERGE, (Object)neighborsJoin.getDriverStrategy());
        Assert.assertEquals((Object)this.set0, (Object)neighborsJoin.getKeysForInput1());
        Assert.assertEquals((Object)this.set0, (Object)neighborsJoin.getKeysForInput2());
        Assert.assertEquals((Object)DriverStrategy.CO_GROUP, (Object)cogroup.getDriverStrategy());
        Assert.assertEquals((Object)this.set0, (Object)cogroup.getKeysForInput1());
        Assert.assertEquals((Object)this.set0, (Object)cogroup.getKeysForInput2());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)iter.getInitialSolutionSetInput().getShipStrategy());
        Assert.assertEquals((Object)this.set0, (Object)iter.getInitialSolutionSetInput().getShipStrategyKeys());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)iter.getInitialWorksetInput().getShipStrategy());
        Assert.assertEquals((Object)this.set0, (Object)iter.getInitialWorksetInput().getShipStrategyKeys());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)neighborsJoin.getInput1().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)neighborsJoin.getInput2().getShipStrategy());
        Assert.assertEquals((Object)this.set0, (Object)neighborsJoin.getInput2().getShipStrategyKeys());
        Assert.assertTrue((boolean)neighborsJoin.getInput2().getTempMode().isCached());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)cogroup.getInput1().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)cogroup.getInput2().getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)sink.getInput().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)iter.getInitialSolutionSetInput().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.SORT, (Object)iter.getInitialWorksetInput().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)neighborsJoin.getInput1().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.SORT, (Object)neighborsJoin.getInput2().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.SORT, (Object)cogroup.getInput1().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)cogroup.getInput2().getLocalStrategy());
        Assert.assertTrue((TempMode.CACHED == neighborsJoin.getInput2().getTempMode() ? 1 : 0) != 0);
        NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
        jgg.compileJobGraph(optPlan);
    }
}

