/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler.examples;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.operators.base.GenericDataSourceBase;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.java.record.operators.FileDataSource;
import eu.stratosphere.api.java.record.operators.JoinOperator;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import eu.stratosphere.test.compiler.util.CompilerTestBase;
import eu.stratosphere.test.compiler.util.OperatorResolver;
import eu.stratosphere.test.recordJobs.relational.TPCHQuery3;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class RelationalQueryCompilerTest
extends CompilerTestBase {
    private static final String ORDERS = "Orders";
    private static final String LINEITEM = "LineItems";
    private static final String MAPPER_NAME = "FilterO";
    private static final String JOIN_NAME = "JoinLiO";
    private final FieldList set0 = new FieldList(0);
    private final FieldList set01 = new FieldList(new int[]{0, 1});

    @Test
    public void testQueryNoStatistics() {
        try {
            TPCHQuery3 query = new TPCHQuery3();
            Plan p = query.getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE);
            OptimizedPlan plan = this.compileNoStats(p);
            CompilerTestBase.OptimizerPlanNodeResolver or = RelationalQueryCompilerTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
            SinkPlanNode sink = (SinkPlanNode)or.getNode("Output");
            SingleInputPlanNode reducer = (SingleInputPlanNode)or.getNode("AggLio");
            SingleInputPlanNode combiner = reducer.getPredecessor() instanceof SingleInputPlanNode ? (SingleInputPlanNode)reducer.getPredecessor() : null;
            DualInputPlanNode join = (DualInputPlanNode)or.getNode(JOIN_NAME);
            SingleInputPlanNode filteringMapper = (SingleInputPlanNode)or.getNode(MAPPER_NAME);
            this.checkStandardStrategies(filteringMapper, join, combiner, reducer, sink);
            Assert.assertTrue((boolean)this.checkRepartitionShipStrategies(join, reducer, combiner));
            Assert.assertTrue((this.checkHashJoinStrategies(join, reducer, true) || this.checkHashJoinStrategies(join, reducer, false) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryAnyValidPlan() {
        this.testQueryGeneric(0x40000000L, 0x200000000L, 0.05f, true, true, true, false, true);
    }

    @Test
    public void testQueryWithSizeZeroInputs() {
        this.testQueryGeneric(0L, 0L, 0.5f, true, true, true, false, true);
    }

    @Test
    public void testQueryWithStatsForBroadcastHash() {
        this.testQueryGeneric(0x10000000000L, 0x10000000000L, 0.05f, true, false, true, false, false);
    }

    @Test
    public void testQueryWithStatsForRepartitionAny() {
        this.testQueryGeneric(0x640000000000L, 0x640000000000L, 0.5f, false, true, true, true, true);
    }

    @Test
    public void testQueryWithStatsForRepartitionMerge() {
        TPCHQuery3 query = new TPCHQuery3();
        Plan p = query.getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE);
        OperatorResolver cr = RelationalQueryCompilerTest.getContractResolver((Plan)p);
        JoinOperator match = (JoinOperator)cr.getNode(JOIN_NAME);
        match.getCompilerHints().setFilterFactor(100.0f);
        this.testQueryGeneric(0x640000000000L, 0x640000000000L, 0.05f, 100.0f, false, true, false, false, true);
    }

    private void testQueryGeneric(long orderSize, long lineItemSize, float ordersFilterFactor, boolean broadcastOkay, boolean partitionedOkay, boolean hashJoinFirstOkay, boolean hashJoinSecondOkay, boolean mergeJoinOkay) {
        this.testQueryGeneric(orderSize, lineItemSize, ordersFilterFactor, ordersFilterFactor, broadcastOkay, partitionedOkay, hashJoinFirstOkay, hashJoinSecondOkay, mergeJoinOkay);
    }

    private void testQueryGeneric(long orderSize, long lineItemSize, float ordersFilterFactor, float joinFilterFactor, boolean broadcastOkay, boolean partitionedOkay, boolean hashJoinFirstOkay, boolean hashJoinSecondOkay, boolean mergeJoinOkay) {
        TPCHQuery3 query = new TPCHQuery3();
        Plan p = query.getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE);
        this.testQueryGeneric(p, orderSize, lineItemSize, ordersFilterFactor, joinFilterFactor, broadcastOkay, partitionedOkay, hashJoinFirstOkay, hashJoinSecondOkay, mergeJoinOkay);
    }

    private void testQueryGeneric(Plan p, long orderSize, long lineitemSize, float orderSelectivity, float joinSelectivity, boolean broadcastOkay, boolean partitionedOkay, boolean hashJoinFirstOkay, boolean hashJoinSecondOkay, boolean mergeJoinOkay) {
        try {
            OperatorResolver cr = RelationalQueryCompilerTest.getContractResolver((Plan)p);
            FileDataSource ordersSource = (FileDataSource)cr.getNode(ORDERS);
            FileDataSource lineItemSource = (FileDataSource)cr.getNode(LINEITEM);
            MapOperator mapper = (MapOperator)cr.getNode(MAPPER_NAME);
            JoinOperator joiner = (JoinOperator)cr.getNode(JOIN_NAME);
            this.setSourceStatistics((GenericDataSourceBase)ordersSource, orderSize, 100.0f);
            this.setSourceStatistics((GenericDataSourceBase)lineItemSource, lineitemSize, 140.0f);
            mapper.getCompilerHints().setAvgOutputRecordSize(16.0f);
            mapper.getCompilerHints().setFilterFactor(orderSelectivity);
            joiner.getCompilerHints().setFilterFactor(joinSelectivity);
            OptimizedPlan plan = this.compileWithStats(p);
            CompilerTestBase.OptimizerPlanNodeResolver or = RelationalQueryCompilerTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
            SinkPlanNode sink = (SinkPlanNode)or.getNode("Output");
            SingleInputPlanNode reducer = (SingleInputPlanNode)or.getNode("AggLio");
            SingleInputPlanNode combiner = reducer.getPredecessor() instanceof SingleInputPlanNode ? (SingleInputPlanNode)reducer.getPredecessor() : null;
            DualInputPlanNode join = (DualInputPlanNode)or.getNode(JOIN_NAME);
            SingleInputPlanNode filteringMapper = (SingleInputPlanNode)or.getNode(MAPPER_NAME);
            this.checkStandardStrategies(filteringMapper, join, combiner, reducer, sink);
            if (this.checkBroadcastShipStrategies(join, reducer, combiner)) {
                Assert.assertTrue((String)"Broadcast join incorrectly chosen.", (boolean)broadcastOkay);
                if (this.checkHashJoinStrategies(join, reducer, true)) {
                    Assert.assertTrue((String)"Hash join (build orders) incorrectly chosen", (boolean)hashJoinFirstOkay);
                } else if (this.checkHashJoinStrategies(join, reducer, false)) {
                    Assert.assertTrue((String)"Hash join (build lineitem) incorrectly chosen", (boolean)hashJoinSecondOkay);
                } else if (this.checkBroadcastMergeJoin(join, reducer)) {
                    Assert.assertTrue((String)"Merge join incorrectly chosen", (boolean)mergeJoinOkay);
                } else {
                    Assert.fail((String)"Plan has no correct hash join or merge join strategies.");
                }
            } else if (this.checkRepartitionShipStrategies(join, reducer, combiner)) {
                Assert.assertTrue((String)"Partitioned join incorrectly chosen.", (boolean)partitionedOkay);
                if (this.checkHashJoinStrategies(join, reducer, true)) {
                    Assert.assertTrue((String)"Hash join (build orders) incorrectly chosen", (boolean)hashJoinFirstOkay);
                } else if (this.checkHashJoinStrategies(join, reducer, false)) {
                    Assert.assertTrue((String)"Hash join (build lineitem) incorrectly chosen", (boolean)hashJoinSecondOkay);
                } else if (this.checkRepartitionMergeJoin(join, reducer)) {
                    Assert.assertTrue((String)"Merge join incorrectly chosen", (boolean)mergeJoinOkay);
                } else {
                    Assert.fail((String)"Plan has no correct hash join or merge join strategies.");
                }
            } else {
                Assert.fail((String)"Plan has neither correct BC join or partitioned join configuration.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkStandardStrategies(SingleInputPlanNode map, DualInputPlanNode join, SingleInputPlanNode combiner, SingleInputPlanNode reducer, SinkPlanNode sink) {
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)map.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
        Assert.assertEquals((Object)DriverStrategy.COLLECTOR_MAP, (Object)map.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_REDUCE, (Object)reducer.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.NONE, (Object)sink.getDriverStrategy());
        if (combiner != null) {
            Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)combiner.getInput().getLocalStrategy());
        }
    }

    private boolean checkBroadcastShipStrategies(DualInputPlanNode join, SingleInputPlanNode reducer, SingleInputPlanNode combiner) {
        if (ShipStrategyType.BROADCAST == join.getInput1().getShipStrategy() && ShipStrategyType.FORWARD == join.getInput2().getShipStrategy() && ShipStrategyType.PARTITION_HASH == reducer.getInput().getShipStrategy()) {
            Assert.assertNotNull((String)"Plan should have a combiner", (Object)combiner);
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
            return true;
        }
        return false;
    }

    private boolean checkRepartitionShipStrategies(DualInputPlanNode join, SingleInputPlanNode reducer, SingleInputPlanNode combiner) {
        if (ShipStrategyType.PARTITION_HASH == join.getInput1().getShipStrategy() && ShipStrategyType.PARTITION_HASH == join.getInput2().getShipStrategy() && ShipStrategyType.FORWARD == reducer.getInput().getShipStrategy()) {
            Assert.assertNull((String)"Plan should not have a combiner", (Object)combiner);
            return true;
        }
        return false;
    }

    private boolean checkHashJoinStrategies(DualInputPlanNode join, SingleInputPlanNode reducer, boolean buildFirst) {
        if (buildFirst && DriverStrategy.HYBRIDHASH_BUILD_FIRST == join.getDriverStrategy() || !buildFirst && DriverStrategy.HYBRIDHASH_BUILD_SECOND == join.getDriverStrategy()) {
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput1());
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput2());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)join.getInput1().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)join.getInput2().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer.getInput().getLocalStrategy());
            Assert.assertEquals((Object)this.set01, (Object)reducer.getInput().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set01, (Object)reducer.getKeys());
            Assert.assertTrue((boolean)Arrays.equals(reducer.getInput().getLocalStrategySortOrder(), reducer.getSortOrders()));
            return true;
        }
        return false;
    }

    private boolean checkBroadcastMergeJoin(DualInputPlanNode join, SingleInputPlanNode reducer) {
        if (DriverStrategy.MERGE == join.getDriverStrategy()) {
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput1());
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput2());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput1().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput2().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer.getInput().getLocalStrategy());
            Assert.assertEquals((Object)this.set0, (Object)join.getInput1().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set0, (Object)join.getInput2().getLocalStrategyKeys());
            Assert.assertTrue((boolean)Arrays.equals(join.getInput1().getLocalStrategySortOrder(), join.getInput2().getLocalStrategySortOrder()));
            Assert.assertEquals((Object)this.set01, (Object)reducer.getInput().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set01, (Object)reducer.getKeys());
            Assert.assertTrue((boolean)Arrays.equals(reducer.getInput().getLocalStrategySortOrder(), reducer.getSortOrders()));
            return true;
        }
        return false;
    }

    private boolean checkRepartitionMergeJoin(DualInputPlanNode join, SingleInputPlanNode reducer) {
        if (DriverStrategy.MERGE == join.getDriverStrategy()) {
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput1());
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput2());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput1().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput2().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)reducer.getInput().getLocalStrategy());
            Assert.assertEquals((Object)this.set01, (Object)join.getInput1().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set0, (Object)join.getInput2().getLocalStrategyKeys());
            Assert.assertTrue((join.getInput1().getLocalStrategySortOrder()[0] == join.getInput2().getLocalStrategySortOrder()[0] ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.set01, (Object)reducer.getKeys());
            Assert.assertTrue((boolean)Arrays.equals(join.getInput1().getLocalStrategySortOrder(), reducer.getSortOrders()));
            return true;
        }
        return false;
    }
}

