/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.util;

import eu.stratosphere.types.Value;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Tuple
implements Value {
    private static final long serialVersionUID = 1L;
    private byte[] bytes;
    private int[] offsets;
    private int numCols;

    public Tuple() {
        this.numCols = 0;
    }

    public Tuple(byte[] bytes, int[] offsets, int cols) {
        this.bytes = bytes;
        this.offsets = offsets;
        this.numCols = cols;
    }

    public int getNumberOfColumns() {
        return this.numCols;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getColumnLength(int colNumber) {
        if (this.offsets == null) {
            return -1;
        }
        if (colNumber < 0) {
            return -1;
        }
        if (colNumber >= this.offsets.length) {
            return -1;
        }
        return this.offsets[colNumber + 1] - this.offsets[colNumber] - 1;
    }

    public void concatenate(Tuple other) {
        if (other.getBytes() == null) {
            return;
        }
        if (this.bytes == null) {
            this.bytes = (byte[])other.bytes.clone();
            this.offsets = (int[])other.offsets.clone();
            this.numCols = other.numCols;
        } else {
            Object[] tmp;
            int len = this.offsets[this.numCols];
            int otherLen = other.offsets[other.numCols];
            int totalLen = len + otherLen;
            if (this.bytes.length < totalLen) {
                tmp = new byte[totalLen];
                System.arraycopy(this.bytes, 0, tmp, 0, len);
                this.bytes = tmp;
            }
            System.arraycopy(other.bytes, 0, this.bytes, len, otherLen);
            if (this.offsets.length < this.numCols + other.numCols + 1) {
                tmp = new int[this.numCols + other.numCols + 1];
                System.arraycopy(this.offsets, 0, tmp, 0, this.numCols + 1);
                this.offsets = tmp;
            }
            for (int i = 1; i < other.numCols + 1; ++i) {
                this.offsets[this.numCols + i] = other.offsets[i] + len;
            }
            this.numCols += other.numCols;
        }
    }

    public void project(int bitmap) {
        int[] lengths = new int[this.numCols];
        int lenCount = 0;
        if (this.bytes == null || this.offsets == null) {
            return;
        }
        int k = 0;
        for (int i = 0; bitmap != 0 && i < this.numCols; ++i, bitmap >>>= 1) {
            int len;
            if ((bitmap & 1) == 0) continue;
            lengths[k] = len = this.offsets[i + 1] - this.offsets[i];
            lenCount += len;
            this.offsets[k] = this.offsets[i];
            ++k;
        }
        this.numCols = k;
        byte[] tmp = new byte[lenCount];
        lenCount = 0;
        for (int i = 0; i < k; ++i) {
            System.arraycopy(this.bytes, this.offsets[i], tmp, lenCount, lengths[i]);
            this.offsets[i] = lenCount;
            lenCount += lengths[i];
        }
        this.bytes = tmp;
        this.offsets[this.numCols] = tmp.length;
    }

    public int compareStringAttribute(Tuple other, int thisColumn, int otherColumn) {
        if (thisColumn < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (otherColumn < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (thisColumn >= this.numCols) {
            throw new IndexOutOfBoundsException();
        }
        if (otherColumn >= other.numCols) {
            throw new IndexOutOfBoundsException();
        }
        int len = this.getColumnLength(thisColumn);
        int otherLen = other.getColumnLength(otherColumn);
        int min = Math.min(len, otherLen);
        int startPos = this.offsets[thisColumn];
        int otherStartPos = other.offsets[otherColumn];
        for (int i = 0; i < min; ++i) {
            if (this.bytes[startPos + i] < other.bytes[otherStartPos + i]) {
                return -1;
            }
            if (this.bytes[startPos + i] <= other.bytes[otherStartPos + i]) continue;
            return 1;
        }
        if (len < otherLen) {
            return -1;
        }
        if (len > otherLen) {
            return 1;
        }
        return 0;
    }

    public int compareIntAttribute(Tuple other, int thisColumn, int otherColumn) {
        int len = this.getColumnLength(thisColumn);
        int otherLen = other.getColumnLength(otherColumn);
        if (thisColumn < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (otherColumn < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (thisColumn >= this.numCols) {
            throw new IndexOutOfBoundsException();
        }
        if (otherColumn >= other.numCols) {
            throw new IndexOutOfBoundsException();
        }
        int thisNegative = 1;
        int otherNegative = 1;
        if (this.bytes[this.offsets[thisColumn]] == 45) {
            thisNegative = -1;
        }
        if (other.getBytes()[other.offsets[otherColumn]] == 45) {
            otherNegative = -1;
        }
        if (thisNegative != otherNegative) {
            return thisNegative;
        }
        if (len < otherLen) {
            return -1 * thisNegative;
        }
        if (len > otherLen) {
            return 1 * thisNegative;
        }
        int myStartPos = this.offsets[thisColumn];
        int compStartPos = other.offsets[otherColumn];
        for (int i = 0; i < len; ++i) {
            if (this.bytes[myStartPos + i] < other.bytes[compStartPos + i]) {
                return -1 * thisNegative;
            }
            if (this.bytes[myStartPos + i] <= other.bytes[compStartPos + i]) continue;
            return 1 * thisNegative;
        }
        return 0;
    }

    public String getStringValueAt(int column) throws IndexOutOfBoundsException {
        if (column < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (column >= this.numCols) {
            throw new IndexOutOfBoundsException();
        }
        int off = this.offsets[column];
        int len = this.getColumnLength(column);
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(this.bytes[off + i] & 0xFF);
        }
        return new String(chars);
    }

    public long getLongValueAt(int column) throws IndexOutOfBoundsException, NumberFormatException {
        if (column < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (column >= this.numCols) {
            throw new IndexOutOfBoundsException();
        }
        int off = this.offsets[column];
        int len = this.getColumnLength(column);
        boolean isNegative = false;
        if (this.bytes[off] == 45) {
            isNegative = true;
            ++off;
            --len;
        }
        long value = 0L;
        for (int i = off; i < off + len; ++i) {
            if (this.bytes[i] < 48 || this.bytes[i] > 57) {
                throw new NumberFormatException();
            }
            value *= 10L;
            value += (long)(this.bytes[i] - 48);
        }
        if (isNegative) {
            value *= -1L;
        }
        return value;
    }

    public byte[] getByteArrayValueAt(int column) throws IndexOutOfBoundsException {
        if (column < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (column >= this.numCols) {
            throw new IndexOutOfBoundsException();
        }
        int len = this.getColumnLength(column);
        byte[] buffer = new byte[len];
        System.arraycopy(this.bytes, this.offsets[column], buffer, 0, len);
        return buffer;
    }

    public void reserveSpace(int minCapacity) {
        if (this.bytes.length < minCapacity) {
            byte[] tmp = new byte[minCapacity];
            System.arraycopy(this.bytes, 0, tmp, 0, this.offsets[this.numCols]);
            this.bytes = tmp;
        }
    }

    public void compact() {
        Object[] tmp;
        int len = this.offsets[this.numCols];
        if (this.bytes.length > len) {
            tmp = new byte[len];
            System.arraycopy(this.bytes, 0, tmp, 0, len);
            this.bytes = tmp;
        }
        if (this.offsets.length > this.numCols + 1) {
            tmp = new int[this.numCols + 1];
            System.arraycopy(this.offsets, 0, tmp, 0, this.numCols + 1);
            this.offsets = tmp;
        }
    }

    public void addAttribute(byte[] attValue) {
        int end;
        if (this.numCols == 0) {
            this.offsets = new int[5];
            this.bytes = new byte[Math.max(256, attValue.length + 1)];
            end = 0;
        } else {
            Object[] tmp;
            end = this.offsets[this.numCols];
            if (this.numCols + 1 >= this.offsets.length) {
                tmp = new int[this.offsets.length * 2];
                System.arraycopy(this.offsets, 0, tmp, 0, this.numCols + 1);
                this.offsets = tmp;
            }
            if (this.bytes.length < end + attValue.length + 1) {
                tmp = new byte[this.bytes.length + attValue.length + 1];
                System.arraycopy(this.bytes, 0, tmp, 0, end);
                this.bytes = (byte[])tmp;
            }
        }
        System.arraycopy(attValue, 0, this.bytes, end, attValue.length);
        end += attValue.length;
        this.bytes[end++] = 124;
        ++this.numCols;
        this.offsets[this.numCols] = end;
    }

    public void addAttribute(String attValue) {
        int end;
        if (this.numCols == 0) {
            this.offsets = new int[5];
            this.bytes = new byte[Math.max(256, attValue.length() + 1)];
            end = 0;
        } else {
            Object[] tmp;
            end = this.offsets[this.numCols];
            if (this.numCols + 1 >= this.offsets.length) {
                tmp = new int[this.offsets.length * 2];
                System.arraycopy(this.offsets, 0, tmp, 0, this.numCols + 1);
                this.offsets = tmp;
            }
            if (this.bytes.length < end + attValue.length() + 1) {
                tmp = new byte[this.bytes.length + attValue.length() + 1];
                System.arraycopy(this.bytes, 0, tmp, 0, end);
                this.bytes = (byte[])tmp;
            }
        }
        int i = 0;
        while (i < attValue.length()) {
            this.bytes[end] = (byte)(attValue.charAt(i) & 0xFF);
            ++i;
            ++end;
        }
        this.bytes[end++] = 124;
        ++this.numCols;
        this.offsets[this.numCols] = end;
    }

    public void addAttributeFromKVRecord(Tuple other, int column) {
        int end;
        int len = other.getColumnLength(column) + 1;
        if (this.numCols == 0) {
            this.offsets = new int[5];
            this.bytes = new byte[Math.max(256, len)];
            end = 0;
        } else {
            Object[] tmp;
            end = this.offsets[this.numCols];
            if (this.numCols + 1 >= this.offsets.length) {
                tmp = new int[this.offsets.length * 2];
                System.arraycopy(this.offsets, 0, tmp, 0, this.numCols + 1);
                this.offsets = tmp;
            }
            if (this.bytes.length < end + len) {
                tmp = new byte[end + len];
                System.arraycopy(this.bytes, 0, tmp, 0, end);
                this.bytes = (byte[])tmp;
            }
        }
        System.arraycopy(other.bytes, other.offsets[column], this.bytes, end, len);
        ++this.numCols;
        this.offsets[this.numCols] = end + len;
    }

    public void setContents(byte[] bytes, int offset, int len, char delimiter) {
        if (this.bytes == null || this.bytes.length < len) {
            this.bytes = new byte[len];
        }
        System.arraycopy(bytes, offset, this.bytes, 0, len);
        int readPos = offset;
        if (this.offsets == null) {
            this.offsets = new int[4];
        }
        int col = 1;
        int startPos = readPos;
        while (readPos < offset + len) {
            if (bytes[readPos++] != delimiter) continue;
            if (this.offsets.length <= col) {
                int[] newOffsets = new int[this.offsets.length * 2];
                System.arraycopy(this.offsets, 0, newOffsets, 0, this.offsets.length);
                this.offsets = newOffsets;
            }
            this.offsets[col++] = readPos - startPos;
        }
        this.numCols = col - 1;
    }

    public void read(DataInput in) throws IOException {
        int numBytes = in.readInt();
        if (numBytes > 0) {
            this.bytes = new byte[numBytes];
            in.readFully(this.bytes);
            this.numCols = in.readInt() + 1;
            this.offsets = new int[this.numCols + 1];
            for (int i = 1; i < this.numCols; ++i) {
                this.offsets[i] = in.readInt();
            }
            this.offsets[this.numCols] = numBytes;
        } else {
            this.numCols = 0;
        }
    }

    public void write(DataOutput out) throws IOException {
        int numBytes = this.numCols > 0 ? this.offsets[this.numCols] : 0;
        out.writeInt(numBytes);
        if (numBytes > 0) {
            out.write(this.bytes, 0, numBytes);
            out.writeInt(this.numCols - 1);
            for (int i = 1; i < this.numCols; ++i) {
                out.writeInt(this.offsets[i]);
            }
        }
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < this.numCols; ++i) {
            for (int k = 0; k < this.getColumnLength(i); ++k) {
                bld.append((char)(this.bytes[this.offsets[i] + k] & 0xFF));
            }
            bld.append('|');
        }
        return bld.toString();
    }
}

