/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.sort.tsUtil;

import eu.stratosphere.types.Key;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class TeraKey
implements Key<TeraKey> {
    private static final long serialVersionUID = 1L;
    public static final int KEY_SIZE = 10;
    private byte[] key;
    private int offset;

    public TeraKey(byte[] srcBuf, int offset) {
        this.key = srcBuf;
        this.offset = offset;
    }

    public TeraKey() {
        this.key = new byte[10];
    }

    public void setValue(byte[] data, int offset) {
        this.key = data;
        this.offset = offset;
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.key, this.offset, 10);
    }

    public void read(DataInput in) throws IOException {
        in.readFully(this.key, 0, 10);
        this.offset = 0;
    }

    public int compareTo(TeraKey tsk) {
        int diff = 0;
        for (int i = 0; i < 10 && (diff = this.key[i + this.offset] - tsk.key[i + tsk.offset]) == 0; ++i) {
        }
        return diff;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < 10; ++i) {
            result = 31 * result + this.key[i + this.offset];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TeraKey other = (TeraKey)obj;
        int i = 0;
        int tx = this.offset;
        int ox = other.offset;
        while (i < 10) {
            if (this.key[tx] != other.key[ox]) {
                return false;
            }
            ++i;
            ++tx;
            ++ox;
        }
        return true;
    }

    public void copyToBuffer(byte[] buf) {
        System.arraycopy(this.key, this.offset, buf, 0, 10);
    }

    public String toString() {
        return new String(this.key, this.offset, 10);
    }
}

